/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.trino.cache.NonEvictableLoadingCache;
import io.trino.cache.SafeCaches;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.pinot.ForPinot;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotConfig;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.PinotTableHandle;
import io.trino.plugin.pinot.PinotTypeConverter;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.plugin.pinot.query.AggregateExpression;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.DynamicTableBuilder;
import io.trino.plugin.pinot.query.DynamicTablePqlExtractor;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.plugin.pinot.query.aggregation.ImplementApproxDistinct;
import io.trino.plugin.pinot.query.aggregation.ImplementAvg;
import io.trino.plugin.pinot.query.aggregation.ImplementCountAll;
import io.trino.plugin.pinot.query.aggregation.ImplementCountDistinct;
import io.trino.plugin.pinot.query.aggregation.ImplementMinMax;
import io.trino.plugin.pinot.query.aggregation.ImplementSum;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.pinot.spi.data.Schema;

public class PinotMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "default";
    private static final Set<Type> SUPPORTS_ALWAYS_FALSE = Set.of(BigintType.BIGINT, IntegerType.INTEGER, RealType.REAL, DoubleType.DOUBLE);
    private final NonEvictableLoadingCache<String, Schema> pinotTableSchemaCache;
    private final int maxRowsPerBrokerQuery;
    private final AggregateFunctionRewriter<AggregateExpression, Void> aggregateFunctionRewriter;
    private final ImplementCountDistinct implementCountDistinct;
    private final PinotClient pinotClient;
    private final PinotTypeConverter typeConverter;

    @Inject
    public PinotMetadata(final PinotClient pinotClient, PinotConfig pinotConfig, @ForPinot ExecutorService executor, PinotTypeConverter typeConverter) {
        this.pinotClient = Objects.requireNonNull(pinotClient, "pinotClient is null");
        long metadataCacheExpiryMillis = pinotConfig.getMetadataCacheExpiry().roundTo(TimeUnit.MILLISECONDS);
        this.typeConverter = Objects.requireNonNull(typeConverter, "typeConverter is null");
        this.pinotTableSchemaCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().refreshAfterWrite(metadataCacheExpiryMillis, TimeUnit.MILLISECONDS), (CacheLoader)CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, Schema>(this){

            public Schema load(String tableName) throws Exception {
                return pinotClient.getTableSchema(tableName);
            }
        }, (Executor)executor));
        this.maxRowsPerBrokerQuery = pinotConfig.getMaxRowsForBrokerQueries();
        UnaryOperator<String> identifierQuote = UnaryOperator.identity();
        this.implementCountDistinct = new ImplementCountDistinct(identifierQuote);
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(new ConnectorExpressionRewriter((Set)ImmutableSet.of()), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll()).add((Object)new ImplementAvg(identifierQuote)).add((Object)new ImplementMinMax(identifierQuote)).add((Object)new ImplementSum(identifierQuote)).add((Object)new ImplementApproxDistinct(identifierQuote)).add((Object)this.implementCountDistinct).build());
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)SCHEMA_NAME);
    }

    public PinotTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        if (tableName.getTableName().trim().contains("select ")) {
            DynamicTable dynamicTable = DynamicTableBuilder.buildFromPql(this, tableName, this.pinotClient, this.typeConverter);
            return new PinotTableHandle(tableName.getSchemaName(), dynamicTable.tableName(), false, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty(), Optional.of(dynamicTable));
        }
        String pinotTableName = this.pinotClient.getPinotTableNameFromTrinoTableNameIfExists(tableName.getTableName());
        if (pinotTableName == null) {
            return null;
        }
        return new PinotTableHandle(tableName.getSchemaName(), pinotTableName, PinotMetadata.getFromCache(this.pinotTableSchemaCache, pinotTableName).isEnableColumnBasedNullHandling(), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty(), Optional.empty());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)table;
        if (pinotTableHandle.query().isPresent()) {
            DynamicTable dynamicTable = pinotTableHandle.query().get();
            ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
            for (PinotColumnHandle pinotColumnHandle : dynamicTable.projections()) {
                columnMetadataBuilder.add((Object)pinotColumnHandle.getColumnMetadata());
            }
            dynamicTable.aggregateColumns().forEach(columnHandle -> columnMetadataBuilder.add((Object)columnHandle.getColumnMetadata()));
            SchemaTableName schemaTableName = new SchemaTableName(pinotTableHandle.schemaName(), dynamicTable.tableName());
            return new ConnectorTableMetadata(schemaTableName, (List)columnMetadataBuilder.build());
        }
        SchemaTableName tableName = new SchemaTableName(pinotTableHandle.schemaName(), pinotTableHandle.tableName());
        return new ConnectorTableMetadata(tableName, this.getColumnsMetadata(tableName.getTableName()));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaNameOrNull) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String table : this.pinotClient.getPinotTableNames()) {
            builder.add((Object)new SchemaTableName(SCHEMA_NAME, table));
        }
        return ImmutableList.copyOf((Collection)builder.build());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)tableHandle;
        if (pinotTableHandle.query().isPresent()) {
            return this.getDynamicTableColumnHandles(pinotTableHandle);
        }
        return this.getPinotColumnHandles(pinotTableHandle.tableName());
    }

    public Map<String, ColumnHandle> getPinotColumnHandles(String tableName) {
        ImmutableMap.Builder columnHandlesBuilder = ImmutableMap.builder();
        String pinotTableName = this.pinotClient.getPinotTableNameFromTrinoTableName(tableName);
        for (PinotColumnHandle columnHandle : this.getPinotColumnHandlesForPinotSchema(pinotTableName)) {
            columnHandlesBuilder.put((Object)columnHandle.getColumnName().toLowerCase(Locale.ENGLISH), (Object)columnHandle);
        }
        return columnHandlesBuilder.buildOrThrow();
    }

    public Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        HashMap<SchemaTableName, RelationColumnsMetadata> relationColumns = new HashMap<SchemaTableName, RelationColumnsMetadata>();
        for (SchemaTableName tableName : this.listTables(session, schemaName)) {
            try {
                relationColumns.put(tableName, RelationColumnsMetadata.forTable((SchemaTableName)tableName, this.getColumnsMetadata(tableName.getTableName())));
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return ((Set)relationFilter.apply(relationColumns.keySet())).stream().map(relationColumns::get).iterator();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((PinotColumnHandle)columnHandle).getColumnMetadata();
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        PinotTableHandle handle = (PinotTableHandle)table;
        if (handle.limit().isPresent() && handle.limit().getAsLong() <= limit) {
            return Optional.empty();
        }
        Optional<DynamicTable> dynamicTable = handle.query();
        if (dynamicTable.isPresent() && (dynamicTable.get().limit().isEmpty() || dynamicTable.get().limit().getAsLong() > limit)) {
            dynamicTable = Optional.of(new DynamicTable(dynamicTable.get().tableName(), dynamicTable.get().suffix(), dynamicTable.get().projections(), dynamicTable.get().filter(), dynamicTable.get().groupingColumns(), dynamicTable.get().aggregateColumns(), dynamicTable.get().havingExpression(), dynamicTable.get().orderBy(), OptionalLong.of(limit), dynamicTable.get().offset(), dynamicTable.get().queryOptions(), dynamicTable.get().query()));
        }
        handle = new PinotTableHandle(handle.schemaName(), handle.tableName(), handle.enableNullHandling(), handle.constraint(), OptionalLong.of(limit), dynamicTable);
        boolean singleSplit = dynamicTable.isPresent();
        return Optional.of(new LimitApplicationResult((Object)handle, singleSplit, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain remainingFilter;
        PinotTableHandle handle = (PinotTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.constraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (newDomain.isNone()) {
            remainingFilter = TupleDomain.all();
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            HashMap<ColumnHandle, Domain> supported = new HashMap<ColumnHandle, Domain>();
            HashMap<ColumnHandle, Domain> unsupported = new HashMap<ColumnHandle, Domain>();
            for (Map.Entry entry : domains.entrySet()) {
                Type columnType = ((PinotColumnHandle)entry.getKey()).getDataType();
                if (columnType instanceof ArrayType) {
                    unsupported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
                    continue;
                }
                if (this.typeConverter.isJsonType(columnType)) {
                    unsupported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
                    continue;
                }
                if (this.isFilterPushdownUnsupported((Domain)entry.getValue())) {
                    unsupported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
                    continue;
                }
                supported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        handle = new PinotTableHandle(handle.schemaName(), handle.tableName(), handle.enableNullHandling(), (TupleDomain<ColumnHandle>)newDomain, handle.limit(), handle.query());
        return Optional.of(new ConstraintApplicationResult((Object)handle, remainingFilter, constraint.getExpression(), false));
    }

    private boolean isFilterPushdownUnsupported(Domain domain) {
        ValueSet valueSet = domain.getValues();
        boolean isNotNull = valueSet.isAll() && !domain.isNullAllowed();
        boolean isUnsupportedAlwaysFalse = domain.isNone() && !SUPPORTS_ALWAYS_FALSE.contains(domain.getType());
        boolean isInOrNull = !valueSet.getRanges().getOrderedRanges().isEmpty() && domain.isNullAllowed();
        return isNotNull || domain.isOnlyNull() || isUnsupportedAlwaysFalse || isInOrNull;
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle handle, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        if (!PinotSessionProperties.isAggregationPushdownEnabled(session)) {
            return Optional.empty();
        }
        Verify.verify((!groupingSets.isEmpty() ? 1 : 0) != 0, (String)"No grouping sets provided", (Object[])new Object[0]);
        if (groupingSets.size() != 1) {
            return Optional.empty();
        }
        PinotTableHandle tableHandle = (PinotTableHandle)handle;
        Schema schema = PinotMetadata.getFromCache(this.pinotTableSchemaCache, tableHandle.tableName());
        if (schema.isEnableColumnBasedNullHandling()) {
            return Optional.empty();
        }
        if (((List)Iterables.getOnlyElement(groupingSets)).stream().filter(columnHandle -> ((PinotColumnHandle)columnHandle).getDataType() instanceof ArrayType).findFirst().isPresent()) {
            return Optional.empty();
        }
        if (tableHandle.query().isPresent() && (!this.isAggregationPushdownSupported(session, tableHandle.query(), aggregates, assignments) || !tableHandle.query().get().aggregateColumns().isEmpty() || tableHandle.query().get().aggregateInProjections() || tableHandle.query().get().offset().isPresent())) {
            return Optional.empty();
        }
        ImmutableList.Builder projections = ImmutableList.builder();
        ImmutableList.Builder resultAssignments = ImmutableList.builder();
        ImmutableList.Builder aggregateColumnsBuilder = ImmutableList.builder();
        for (AggregateFunction aggregate : aggregates) {
            Optional<AggregateExpression> rewriteResult = this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
            if ((rewriteResult = this.applyCountDistinct(session, aggregate, assignments, tableHandle, rewriteResult)).isEmpty()) {
                return Optional.empty();
            }
            AggregateExpression aggregateExpression2 = rewriteResult.get();
            PinotColumnHandle pinotColumnHandle = new PinotColumnHandle(aggregateExpression2.fieldName(), aggregate.getOutputType(), aggregateExpression2.expression(), false, true, aggregateExpression2.returnNullOnEmptyGroup(), Optional.of(aggregateExpression2.function()), Optional.of(aggregateExpression2.argument()));
            aggregateColumnsBuilder.add((Object)pinotColumnHandle);
            projections.add((Object)new Variable(pinotColumnHandle.getColumnName(), pinotColumnHandle.getDataType()));
            resultAssignments.add((Object)new Assignment(pinotColumnHandle.getColumnName(), (ColumnHandle)pinotColumnHandle, pinotColumnHandle.getDataType()));
        }
        List groupingColumns = (List)((List)Iterables.getOnlyElement(groupingSets)).stream().map(PinotColumnHandle.class::cast).map(PinotMetadata::toNonAggregateColumnHandle).collect(ImmutableList.toImmutableList());
        OptionalLong limitForDynamicTable = OptionalLong.empty();
        if (tableHandle.limit().isEmpty() && !groupingColumns.isEmpty()) {
            limitForDynamicTable = OptionalLong.of(this.maxRowsPerBrokerQuery + 1);
        }
        Object aggregationColumns = aggregateColumnsBuilder.build();
        String newQuery = "";
        List newSelections = groupingColumns;
        if (tableHandle.query().isPresent()) {
            newQuery = tableHandle.query().get().query();
            Map projectionsMap = (Map)tableHandle.query().get().projections().stream().collect(ImmutableMap.toImmutableMap(PinotColumnHandle::getColumnName, UnaryOperator.identity()));
            groupingColumns = (List)groupingColumns.stream().map(groupIngColumn -> projectionsMap.getOrDefault(groupIngColumn.getColumnName(), groupIngColumn)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder newSelectionsBuilder = ImmutableList.builder().addAll((Iterable)groupingColumns);
            aggregationColumns = (List)aggregationColumns.stream().map(aggregateExpression -> PinotMetadata.resolveAggregateExpressionWithAlias(aggregateExpression, projectionsMap)).collect(ImmutableList.toImmutableList());
            newSelections = newSelectionsBuilder.build();
        }
        DynamicTable dynamicTable = new DynamicTable(tableHandle.tableName(), Optional.empty(), newSelections, tableHandle.query().flatMap(DynamicTable::filter), groupingColumns, (List<PinotColumnHandle>)aggregationColumns, Optional.empty(), (List<OrderByExpression>)ImmutableList.of(), limitForDynamicTable, OptionalLong.empty(), (Map<String, String>)ImmutableMap.of(), newQuery);
        tableHandle = new PinotTableHandle(tableHandle.schemaName(), tableHandle.tableName(), tableHandle.enableNullHandling(), tableHandle.constraint(), tableHandle.limit(), Optional.of(dynamicTable));
        return Optional.of(new AggregationApplicationResult((Object)tableHandle, (List)projections.build(), (List)resultAssignments.build(), (Map)ImmutableMap.of(), false));
    }

    public static PinotColumnHandle toNonAggregateColumnHandle(PinotColumnHandle columnHandle) {
        return new PinotColumnHandle(columnHandle.getColumnName(), columnHandle.getDataType(), DynamicTablePqlExtractor.quoteIdentifier(columnHandle.getColumnName()), false, false, true, Optional.empty(), Optional.empty());
    }

    private boolean isAggregationPushdownSupported(ConnectorSession session, Optional<DynamicTable> dynamicTable, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments) {
        if (dynamicTable.isEmpty()) {
            return true;
        }
        List<PinotColumnHandle> groupingColumns = dynamicTable.get().groupingColumns();
        if (groupingColumns.isEmpty()) {
            return true;
        }
        if (aggregates.size() != 1) {
            return false;
        }
        AggregateFunction aggregate = (AggregateFunction)Iterables.getOnlyElement(aggregates);
        CountDistinctContext context = new CountDistinctContext(assignments, session);
        return this.implementCountDistinct.getPattern().matches((Object)aggregate, (Object)context);
    }

    private Optional<AggregateExpression> applyCountDistinct(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments, PinotTableHandle tableHandle, Optional<AggregateExpression> rewriteResult) {
        CountDistinctContext context = new CountDistinctContext(assignments, session);
        if (this.implementCountDistinct.getPattern().matches((Object)aggregate, (Object)context)) {
            Variable argument = (Variable)Iterables.getOnlyElement((Iterable)aggregate.getArguments());
            PinotColumnHandle columnHandle = (PinotColumnHandle)assignments.get(argument.getName());
            if (tableHandle.query().isEmpty() || tableHandle.query().get().groupingColumns().stream().noneMatch(groupingExpression -> groupingExpression.getColumnName().equals(columnHandle.getColumnName()))) {
                return Optional.empty();
            }
        }
        return rewriteResult;
    }

    private static PinotColumnHandle resolveAggregateExpressionWithAlias(PinotColumnHandle aggregateColumn, Map<String, PinotColumnHandle> projectionsMap) {
        Preconditions.checkState((aggregateColumn.isAggregate() && aggregateColumn.getPushedDownAggregateFunctionName().isPresent() && aggregateColumn.getPushedDownAggregateFunctionArgument().isPresent() ? 1 : 0) != 0, (Object)"Column is not a pushed down aggregate column");
        PinotColumnHandle selection = projectionsMap.get(aggregateColumn.getPushedDownAggregateFunctionArgument().get());
        if (selection != null && selection.isAliased()) {
            AggregateExpression pushedDownAggregateExpression = new AggregateExpression(aggregateColumn.getPushedDownAggregateFunctionName().get(), aggregateColumn.getPushedDownAggregateFunctionArgument().get(), aggregateColumn.isReturnNullOnEmptyGroup());
            AggregateExpression newPushedDownAggregateExpression = AggregateExpression.replaceIdentifier(pushedDownAggregateExpression, selection);
            return new PinotColumnHandle(pushedDownAggregateExpression.fieldName(), aggregateColumn.getDataType(), newPushedDownAggregateExpression.expression(), true, aggregateColumn.isAggregate(), aggregateColumn.isReturnNullOnEmptyGroup(), aggregateColumn.getPushedDownAggregateFunctionName(), Optional.of(newPushedDownAggregateExpression.argument()));
        }
        return aggregateColumn;
    }

    private List<ColumnMetadata> getColumnsMetadata(String tableName) {
        String pinotTableName = this.pinotClient.getPinotTableNameFromTrinoTableName(tableName);
        return (List)this.getPinotColumnHandlesForPinotSchema(pinotTableName).stream().map(PinotColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
    }

    private static <K, V> V getFromCache(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNCLASSIFIED_ERROR, Optional.empty(), "Cannot fetch from cache " + String.valueOf(key), e.getCause());
        }
    }

    private Map<String, ColumnHandle> getDynamicTableColumnHandles(PinotTableHandle pinotTableHandle) {
        Preconditions.checkState((boolean)pinotTableHandle.query().isPresent(), (Object)"dynamic table not present");
        DynamicTable dynamicTable = pinotTableHandle.query().get();
        ImmutableMap.Builder columnHandlesBuilder = ImmutableMap.builder();
        for (PinotColumnHandle pinotColumnHandle : dynamicTable.projections()) {
            columnHandlesBuilder.put((Object)pinotColumnHandle.getColumnName().toLowerCase(Locale.ENGLISH), (Object)pinotColumnHandle);
        }
        dynamicTable.aggregateColumns().forEach(columnHandle -> columnHandlesBuilder.put((Object)columnHandle.getColumnName().toLowerCase(Locale.ENGLISH), columnHandle));
        return columnHandlesBuilder.buildOrThrow();
    }

    private List<PinotColumnHandle> getPinotColumnHandlesForPinotSchema(String tableName) {
        Schema pinotTableSchema = PinotMetadata.getFromCache(this.pinotTableSchemaCache, tableName);
        return (List)pinotTableSchema.getColumnNames().stream().filter(columnName -> !columnName.startsWith("$")).map(columnName -> new PinotColumnHandle((String)columnName, this.typeConverter.toTrinoType(pinotTableSchema.getFieldSpecFor(columnName)))).collect(ImmutableList.toImmutableList());
    }

    private static class CountDistinctContext
    implements AggregateFunctionRule.RewriteContext<Void> {
        private final Map<String, ColumnHandle> assignments;
        private final ConnectorSession session;

        CountDistinctContext(Map<String, ColumnHandle> assignments, ConnectorSession session) {
            this.assignments = Objects.requireNonNull(assignments, "assignments is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public Map<String, ColumnHandle> getAssignments() {
            return this.assignments;
        }

        public ConnectorSession getSession() {
            return this.session;
        }

        public Optional<Void> rewriteExpression(ConnectorExpression expression) {
            throw new UnsupportedOperationException();
        }
    }
}

