/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.client;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotSplit;
import io.trino.plugin.pinot.client.PinotDataTableWithSize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.common.datatable.DataTable;

public interface PinotDataFetcher {
    default public void checkExceptions(DataTable dataTable, PinotSplit split, String query) {
        List exceptions = (List)dataTable.getMetadata().entrySet().stream().filter(metadataEntry -> ((String)metadataEntry.getKey()).startsWith("Exception")).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
        if (!exceptions.isEmpty()) {
            throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(query), String.format("Encountered %d pinot exceptions for split %s: %s", exceptions.size(), split, exceptions));
        }
    }

    public long getReadTimeNanos();

    public long getMemoryUsageBytes();

    public boolean endOfData();

    public boolean isDataFetched();

    public void fetchData();

    public PinotDataTableWithSize getNextDataTable();

    public static interface Factory {
        public PinotDataFetcher create(String var1, PinotSplit var2);

        public int getRowLimit();
    }

    public static class RowCountChecker {
        private final AtomicLong currentRowCount = new AtomicLong();
        private final int limit;
        private final String query;

        public RowCountChecker(int limit, String query) {
            this.limit = limit;
            this.query = Objects.requireNonNull(query, "query is null");
        }

        public void checkTooManyRows(DataTable dataTable) {
            if (this.currentRowCount.addAndGet(dataTable.getNumberOfRows()) > (long)this.limit) {
                throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(this.query), String.format("Segment query returned '%s' rows per split, maximum allowed is '%s' rows.", this.currentRowCount.get(), this.limit));
            }
        }
    }
}

