/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.conversion;

import com.google.common.primitives.Longs;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class PinotTimestamps {
    private static final DateTimeFormatter PINOT_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSS][.SS][.S]");

    private PinotTimestamps() {
    }

    public static long toMicros(long millis) {
        return millis * 1000L;
    }

    public static long toMicros(Instant instant) {
        return PinotTimestamps.toMicros(instant.toEpochMilli());
    }

    public static LocalDateTime tryParse(String value) {
        Long epochMillis = Longs.tryParse((String)value);
        if (epochMillis != null) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC);
        }
        LocalDateTime timestamp = PinotTimestamps.tryParse(PINOT_TIMESTAMP_FORMATTER, value);
        if (timestamp == null) {
            timestamp = PinotTimestamps.tryParse(DateTimeFormatter.ISO_INSTANT, value);
        }
        return timestamp;
    }

    private static LocalDateTime tryParse(DateTimeFormatter formatter, String value) {
        try {
            return formatter.parse((CharSequence)value, LocalDateTime::from);
        }
        catch (DateTimeParseException dateTimeParseException) {
            return null;
        }
    }
}

