/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.decoders;

import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.decoders.ArrayDecoder;
import io.trino.plugin.pinot.decoders.BigintDecoder;
import io.trino.plugin.pinot.decoders.BooleanDecoder;
import io.trino.plugin.pinot.decoders.Decoder;
import io.trino.plugin.pinot.decoders.DoubleDecoder;
import io.trino.plugin.pinot.decoders.IntegerDecoder;
import io.trino.plugin.pinot.decoders.JsonDecoder;
import io.trino.plugin.pinot.decoders.RealDecoder;
import io.trino.plugin.pinot.decoders.TimestampDecoder;
import io.trino.plugin.pinot.decoders.VarbinaryDecoder;
import io.trino.plugin.pinot.decoders.VarcharDecoder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import java.util.Objects;
import java.util.Optional;

public class DecoderFactory {
    private DecoderFactory() {
    }

    public static Decoder createDecoder(Type type) {
        Objects.requireNonNull(type, "type is null");
        if (type instanceof FixedWidthType) {
            if (type instanceof DoubleType) {
                return new DoubleDecoder();
            }
            if (type instanceof RealType) {
                return new RealDecoder();
            }
            if (type instanceof BigintType) {
                return new BigintDecoder();
            }
            if (type instanceof IntegerType || type instanceof DateType) {
                return new IntegerDecoder();
            }
            if (type instanceof BooleanType) {
                return new BooleanDecoder();
            }
            if (type instanceof TimestampType) {
                return new TimestampDecoder();
            }
            throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "type '" + String.valueOf(type) + "' not supported");
        }
        if (type instanceof ArrayType) {
            return new ArrayDecoder(type);
        }
        if (type instanceof VarbinaryType) {
            return new VarbinaryDecoder();
        }
        if (type.getTypeSignature().getBase().equals("json")) {
            return new JsonDecoder();
        }
        return new VarcharDecoder();
    }
}

