/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.plugin.pinot.query.PinotQueryBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class DynamicTablePqlExtractor {
    private DynamicTablePqlExtractor() {
    }

    public static String extractPql(DynamicTable table, TupleDomain<ColumnHandle> tupleDomain) {
        Optional<String> havingClause;
        StringBuilder builder = new StringBuilder();
        Map<String, String> queryOptions = table.queryOptions();
        queryOptions.keySet().stream().sorted().forEach(key -> builder.append("SET ").append((String)key).append(" = ").append(String.format("'%s'", queryOptions.get(key))).append(";\n"));
        builder.append("SELECT ");
        if (!table.projections().isEmpty()) {
            builder.append(table.projections().stream().map(DynamicTablePqlExtractor::formatExpression).collect(Collectors.joining(", ")));
        }
        if (!table.aggregateColumns().isEmpty()) {
            if (!table.projections().isEmpty()) {
                builder.append(", ");
            }
            builder.append(table.aggregateColumns().stream().map(DynamicTablePqlExtractor::formatExpression).collect(Collectors.joining(", ")));
        }
        builder.append(" FROM ");
        builder.append(table.tableName());
        builder.append(table.suffix().orElse(""));
        Optional<String> filter = DynamicTablePqlExtractor.getFilter(table.filter(), tupleDomain, false);
        if (filter.isPresent()) {
            builder.append(" WHERE ").append(filter.get());
        }
        if (!table.groupingColumns().isEmpty()) {
            builder.append(" GROUP BY ");
            builder.append(table.groupingColumns().stream().map(PinotColumnHandle::getExpression).collect(Collectors.joining(", ")));
        }
        if ((havingClause = DynamicTablePqlExtractor.getFilter(table.havingExpression(), tupleDomain, true)).isPresent()) {
            builder.append(" HAVING ").append(havingClause.get());
        }
        if (!table.orderBy().isEmpty()) {
            builder.append(" ORDER BY ").append(table.orderBy().stream().map(DynamicTablePqlExtractor::convertOrderByExpressionToPql).collect(Collectors.joining(", ")));
        }
        if (table.limit().isPresent()) {
            builder.append(" LIMIT ");
            if (table.offset().isPresent()) {
                builder.append(table.offset().getAsLong()).append(", ");
            }
            builder.append(table.limit().getAsLong());
        }
        return builder.toString();
    }

    private static Optional<String> getFilter(Optional<String> filter, TupleDomain<ColumnHandle> tupleDomain, boolean forHavingClause) {
        Optional<String> tupleFilter = PinotQueryBuilder.getFilterClause(tupleDomain, Optional.empty(), forHavingClause);
        if (tupleFilter.isPresent() && filter.isPresent()) {
            return Optional.of(String.format("%s AND %s", DynamicTablePqlExtractor.encloseInParentheses(tupleFilter.get()), DynamicTablePqlExtractor.encloseInParentheses(filter.get())));
        }
        if (filter.isPresent()) {
            return filter;
        }
        if (tupleFilter.isPresent()) {
            return tupleFilter;
        }
        return Optional.empty();
    }

    private static String convertOrderByExpressionToPql(OrderByExpression orderByExpression) {
        Objects.requireNonNull(orderByExpression, "orderByExpression is null");
        StringBuilder builder = new StringBuilder().append(orderByExpression.expression());
        if (!orderByExpression.asc()) {
            builder.append(" DESC");
        }
        return builder.toString();
    }

    public static String encloseInParentheses(String value) {
        return String.format("(%s)", value);
    }

    private static String formatExpression(PinotColumnHandle pinotColumnHandle) {
        if (pinotColumnHandle.isAliased()) {
            return pinotColumnHandle.getExpression() + " AS " + DynamicTablePqlExtractor.quoteIdentifier(pinotColumnHandle.getColumnName());
        }
        return pinotColumnHandle.getExpression();
    }

    public static String quoteIdentifier(String identifier) {
        return String.format("\"%s\"", identifier.replaceAll("\"", "\"\""));
    }
}

