/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import org.apache.pinot.common.proto.Server;

public class PinotProxyGrpcRequestBuilder {
    private static final String KEY_OF_PROXY_GRPC_FORWARD_HOST = "FORWARD_HOST";
    private static final String KEY_OF_PROXY_GRPC_FORWARD_PORT = "FORWARD_PORT";
    private String hostName;
    private int port = -1;
    private int requestId;
    private String brokerId = "unknown";
    private boolean enableTrace;
    private boolean enableStreaming;
    private String payloadType;
    private String sql;
    private List<String> segments;

    public PinotProxyGrpcRequestBuilder setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public PinotProxyGrpcRequestBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public PinotProxyGrpcRequestBuilder setRequestId(int requestId) {
        this.requestId = requestId;
        return this;
    }

    public PinotProxyGrpcRequestBuilder setBrokerId(String brokerId) {
        this.brokerId = brokerId;
        return this;
    }

    public PinotProxyGrpcRequestBuilder setEnableTrace(boolean enableTrace) {
        this.enableTrace = enableTrace;
        return this;
    }

    public PinotProxyGrpcRequestBuilder setEnableStreaming(boolean enableStreaming) {
        this.enableStreaming = enableStreaming;
        return this;
    }

    public PinotProxyGrpcRequestBuilder setSql(String sql) {
        this.payloadType = "sql";
        this.sql = sql;
        return this;
    }

    public PinotProxyGrpcRequestBuilder setSegments(List<String> segments) {
        this.segments = ImmutableList.copyOf(segments);
        return this;
    }

    public Server.ServerRequest build() {
        if (!this.payloadType.equals("sql")) {
            throw new RuntimeException("Only [SQL] Payload type is allowed: " + this.payloadType);
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("requestId", Integer.toString(this.requestId));
        metadata.put("brokerId", this.brokerId);
        metadata.put("enableTrace", Boolean.toString(this.enableTrace));
        metadata.put("enableStreaming", Boolean.toString(this.enableStreaming));
        metadata.put("payloadType", this.payloadType);
        if (this.hostName != null) {
            metadata.put(KEY_OF_PROXY_GRPC_FORWARD_HOST, this.hostName);
        }
        if (this.port > 0) {
            metadata.put(KEY_OF_PROXY_GRPC_FORWARD_PORT, String.valueOf(this.port));
        }
        return Server.ServerRequest.newBuilder().putAllMetadata(metadata).setSql(this.sql).addAllSegments(this.segments).build();
    }
}

