/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateBehavior {
    LOG("LOG"),
    UPDATE_IN_DATABASE("UPDATE_IN_DATABASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateBehavior> VALUE_MAP;
    private final String value;

    private UpdateBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateBehavior> knownValues() {
        EnumSet<UpdateBehavior> knownValues = EnumSet.allOf(UpdateBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateBehavior.class, UpdateBehavior::toString);
    }
}

