/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.annotations.metrics;

import java.util.function.Function;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.metrics.NoopPinotMetricsRegistry;
import org.apache.pinot.spi.metrics.PinotGauge;
import org.apache.pinot.spi.metrics.PinotJmxReporter;
import org.apache.pinot.spi.metrics.PinotMetricName;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;

public interface PinotMetricsFactory {
    public void init(PinotConfiguration var1);

    public PinotMetricsRegistry getPinotMetricsRegistry();

    public PinotMetricName makePinotMetricName(Class<?> var1, String var2);

    public <T> PinotGauge<T> makePinotGauge(Function<Void, T> var1);

    public PinotJmxReporter makePinotJmxReporter(PinotMetricsRegistry var1);

    public String getMetricsFactoryName();

    public static class Noop
    implements PinotMetricsFactory {
        private final NoopPinotMetricsRegistry _registry = new NoopPinotMetricsRegistry();

        @Override
        public void init(PinotConfiguration metricsConfiguration) {
        }

        @Override
        public PinotMetricsRegistry getPinotMetricsRegistry() {
            return this._registry;
        }

        @Override
        public PinotMetricName makePinotMetricName(Class<?> klass, String name) {
            return () -> "noopMetricName";
        }

        @Override
        public <T> PinotGauge<T> makePinotGauge(Function<Void, T> condition) {
            return this._registry.newGauge();
        }

        @Override
        public PinotJmxReporter makePinotJmxReporter(PinotMetricsRegistry metricsRegistry) {
            return () -> {};
        }

        @Override
        public String getMetricsFactoryName() {
            return "noop";
        }
    }
}

