/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.utils.JsonUtils;

public class ConfigUtils {
    private static final Map<String, String> ENVIRONMENT_VARIABLES = System.getenv();

    private ConfigUtils() {
    }

    public static <T extends BaseJsonConfig> T applyConfigWithEnvVariablesAndSystemProperties(T config) {
        HashMap<String, String> combinedMap = new HashMap<String, String>();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> combinedMap.put(String.valueOf(key), String.valueOf(value))));
        combinedMap.putAll(ENVIRONMENT_VARIABLES);
        return ConfigUtils.applyConfigWithEnvVariablesAndSystemProperties(combinedMap, config);
    }

    public static <T extends BaseJsonConfig> T applyConfigWithEnvVariablesAndSystemProperties(Map<String, String> configValues, T configTemplate) {
        JsonNode jsonNode;
        try {
            jsonNode = ConfigUtils.applyConfigWithEnvVariablesAndSystemProperties(configValues, configTemplate.toJsonNode());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Unable to apply environment variables on json config class [%s].", configTemplate.getClass().getName()), e);
        }
        try {
            return (T)((BaseJsonConfig)JsonUtils.jsonNodeToObject(jsonNode, configTemplate.getClass()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read JsonConfig to class [%s] after applying environment variables, jsonConfig is: '%s'.", configTemplate.getClass().getName(), jsonNode.toString()), e);
        }
    }

    private static JsonNode applyConfigWithEnvVariablesAndSystemProperties(Map<String, String> configValues, JsonNode jsonNode) {
        JsonNodeType nodeType = jsonNode.getNodeType();
        switch (nodeType) {
            case OBJECT: {
                if (jsonNode.isEmpty()) break;
                Iterator iterator = jsonNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry next = (Map.Entry)iterator.next();
                    next.setValue(ConfigUtils.applyConfigWithEnvVariablesAndSystemProperties(configValues, (JsonNode)next.getValue()));
                }
                break;
            }
            case ARRAY: {
                if (!jsonNode.isArray()) break;
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    JsonNode arrayElement = arrayNode.get(i);
                    arrayNode.set(i, ConfigUtils.applyConfigWithEnvVariablesAndSystemProperties(configValues, arrayElement));
                }
                break;
            }
            case STRING: {
                String field = jsonNode.asText();
                if (!field.startsWith("${") || !field.endsWith("}")) break;
                String[] envVarSplits = field.substring(2, field.length() - 1).split(":", 2);
                String envVarKey = envVarSplits[0];
                String value = configValues.get(envVarKey);
                if (value != null) {
                    return JsonNodeFactory.instance.textNode(value);
                }
                if (envVarSplits.length > 1) {
                    return JsonNodeFactory.instance.textNode(envVarSplits[1]);
                }
                throw new RuntimeException("Missing environment Variable: " + envVarKey);
            }
        }
        return jsonNode;
    }
}

