/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.pinot.spi.config.table.IndexConfig;

public class BloomFilterConfig
extends IndexConfig {
    public static final double DEFAULT_FPP = 0.05;
    public static final BloomFilterConfig DEFAULT = new BloomFilterConfig(0.05, 0, false);
    public static final BloomFilterConfig DISABLED = new BloomFilterConfig(true, 0.05, 0, false);
    private final double _fpp;
    private final int _maxSizeInBytes;
    private final boolean _loadOnHeap;

    public BloomFilterConfig(double fpp, int maxSizeInBytes, boolean loadOnHeap) {
        this(false, fpp, maxSizeInBytes, loadOnHeap);
    }

    @JsonCreator
    public BloomFilterConfig(@JsonProperty(value="disabled") Boolean disabled, @JsonProperty(value="fpp") double fpp, @JsonProperty(value="maxSizeInBytes") int maxSizeInBytes, @JsonProperty(value="loadOnHeap") boolean loadOnHeap) {
        super(disabled);
        if (fpp != 0.0) {
            Preconditions.checkArgument((fpp > 0.0 && fpp < 1.0 ? 1 : 0) != 0, (String)"Invalid fpp (false positive probability): %s", (Object)fpp);
            this._fpp = fpp;
        } else {
            this._fpp = 0.05;
        }
        this._maxSizeInBytes = maxSizeInBytes;
        this._loadOnHeap = loadOnHeap;
    }

    public double getFpp() {
        return this._fpp;
    }

    public int getMaxSizeInBytes() {
        return this._maxSizeInBytes;
    }

    public boolean isLoadOnHeap() {
        return this._loadOnHeap;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BloomFilterConfig that = (BloomFilterConfig)o;
        return Double.compare(that._fpp, this._fpp) == 0 && this._maxSizeInBytes == that._maxSizeInBytes && this._loadOnHeap == that._loadOnHeap && this.isEnabled() == that.isEnabled();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._fpp, this._maxSizeInBytes, this._loadOnHeap, this.isEnabled());
    }
}

