/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class QueryConfig
extends BaseJsonConfig {
    private final Long _timeoutMs;
    private final Boolean _disableGroovy;
    private final Boolean _useApproximateFunction;
    private final Map<String, String> _expressionOverrideMap;
    private final Long _maxQueryResponseSizeBytes;
    private final Long _maxServerResponseSizeBytes;

    @JsonCreator
    public QueryConfig(@JsonProperty(value="timeoutMs") @Nullable Long timeoutMs, @JsonProperty(value="disableGroovy") @Nullable Boolean disableGroovy, @JsonProperty(value="useApproximateFunction") @Nullable Boolean useApproximateFunction, @JsonProperty(value="expressionOverrideMap") @Nullable Map<String, String> expressionOverrideMap, @JsonProperty(value="maxQueryResponseSizeBytes") @Nullable Long maxQueryResponseSizeBytes, @JsonProperty(value="maxServerResponseSizeBytes") @Nullable Long maxServerResponseSizeBytes) {
        Preconditions.checkArgument((timeoutMs == null || timeoutMs > 0L ? 1 : 0) != 0, (String)"Invalid 'timeoutMs': %s", (Object)timeoutMs);
        Preconditions.checkArgument((maxQueryResponseSizeBytes == null || maxQueryResponseSizeBytes > 0L ? 1 : 0) != 0, (String)"Invalid 'maxQueryResponseSizeBytes': %s", (Object)maxQueryResponseSizeBytes);
        Preconditions.checkArgument((maxServerResponseSizeBytes == null || maxServerResponseSizeBytes > 0L ? 1 : 0) != 0, (String)"Invalid 'maxServerResponseSizeBytes': %s", (Object)maxServerResponseSizeBytes);
        this._timeoutMs = timeoutMs;
        this._disableGroovy = disableGroovy;
        this._useApproximateFunction = useApproximateFunction;
        this._expressionOverrideMap = expressionOverrideMap;
        this._maxQueryResponseSizeBytes = maxQueryResponseSizeBytes;
        this._maxServerResponseSizeBytes = maxServerResponseSizeBytes;
    }

    @Nullable
    @JsonProperty(value="timeoutMs")
    public Long getTimeoutMs() {
        return this._timeoutMs;
    }

    @Nullable
    @JsonProperty(value="disableGroovy")
    public Boolean getDisableGroovy() {
        return this._disableGroovy;
    }

    @Nullable
    @JsonProperty(value="useApproximateFunction")
    public Boolean getUseApproximateFunction() {
        return this._useApproximateFunction;
    }

    @Nullable
    @JsonProperty(value="expressionOverrideMap")
    public Map<String, String> getExpressionOverrideMap() {
        return this._expressionOverrideMap;
    }

    @Nullable
    @JsonProperty(value="maxQueryResponseSizeBytes")
    public Long getMaxQueryResponseSizeBytes() {
        return this._maxQueryResponseSizeBytes;
    }

    @Nullable
    @JsonProperty(value="maxServerResponseSizeBytes")
    public Long getMaxServerResponseSizeBytes() {
        return this._maxServerResponseSizeBytes;
    }
}

