/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.utils.DataSizeUtils;

public class StarTreeAggregationConfig
extends BaseJsonConfig {
    private final String _columnName;
    private final String _aggregationFunction;
    private final FieldConfig.CompressionCodec _compressionCodec;
    private final Boolean _deriveNumDocsPerChunk;
    private final Integer _indexVersion;
    private final String _targetMaxChunkSize;
    private final Integer _targetMaxChunkSizeBytes;
    private final Integer _targetDocsPerChunk;

    @VisibleForTesting
    public StarTreeAggregationConfig(String columnName, String aggregationFunction) {
        this(columnName, aggregationFunction, null, null, null, null, null);
    }

    @JsonCreator
    public StarTreeAggregationConfig(@JsonProperty(value="columnName", required=true) String columnName, @JsonProperty(value="aggregationFunction", required=true) String aggregationFunction, @JsonProperty(value="compressionCodec") @Nullable FieldConfig.CompressionCodec compressionCodec, @JsonProperty(value="deriveNumDocsPerChunk") @Nullable Boolean deriveNumDocsPerChunk, @JsonProperty(value="indexVersion") @Nullable Integer indexVersion, @JsonProperty(value="targetMaxChunkSize") @Nullable String targetMaxChunkSize, @JsonProperty(value="targetDocsPerChunk") @Nullable Integer targetDocsPerChunk) {
        this._columnName = columnName;
        this._aggregationFunction = aggregationFunction;
        this._compressionCodec = compressionCodec;
        this._deriveNumDocsPerChunk = deriveNumDocsPerChunk;
        this._indexVersion = indexVersion;
        this._targetMaxChunkSize = targetMaxChunkSize;
        this._targetMaxChunkSizeBytes = targetMaxChunkSize != null ? Integer.valueOf((int)DataSizeUtils.toBytes(targetMaxChunkSize)) : null;
        this._targetDocsPerChunk = targetDocsPerChunk;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public String getAggregationFunction() {
        return this._aggregationFunction;
    }

    @Nullable
    public FieldConfig.CompressionCodec getCompressionCodec() {
        return this._compressionCodec;
    }

    @Nullable
    public Boolean getDeriveNumDocsPerChunk() {
        return this._deriveNumDocsPerChunk;
    }

    @Nullable
    public Integer getIndexVersion() {
        return this._indexVersion;
    }

    @Nullable
    public String getTargetMaxChunkSize() {
        return this._targetMaxChunkSize;
    }

    @JsonIgnore
    @Nullable
    public Integer getTargetMaxChunkSizeBytes() {
        return this._targetMaxChunkSizeBytes;
    }

    @Nullable
    public Integer getTargetDocsPerChunk() {
        return this._targetDocsPerChunk;
    }
}

