/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.StarTreeAggregationConfig;

public class StarTreeIndexConfig
extends BaseJsonConfig {
    private final List<String> _dimensionsSplitOrder;
    private final List<String> _skipStarNodeCreationForDimensions;
    private final List<String> _functionColumnPairs;
    private final List<StarTreeAggregationConfig> _aggregationConfigs;
    private final int _maxLeafRecords;

    @JsonCreator
    public StarTreeIndexConfig(@JsonProperty(value="dimensionsSplitOrder", required=true) List<String> dimensionsSplitOrder, @JsonProperty(value="skipStarNodeCreationForDimensions") @Nullable List<String> skipStarNodeCreationForDimensions, @JsonProperty(value="functionColumnPairs") @Nullable List<String> functionColumnPairs, @JsonProperty(value="aggregationConfigs") @Nullable List<StarTreeAggregationConfig> aggregationConfigs, @JsonProperty(value="maxLeafRecords") int maxLeafRecords) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(dimensionsSplitOrder), (Object)"'dimensionsSplitOrder' must be configured");
        this._dimensionsSplitOrder = dimensionsSplitOrder;
        this._skipStarNodeCreationForDimensions = CollectionUtils.isNotEmpty(skipStarNodeCreationForDimensions) ? skipStarNodeCreationForDimensions : null;
        this._functionColumnPairs = CollectionUtils.isNotEmpty(functionColumnPairs) ? functionColumnPairs : null;
        this._aggregationConfigs = CollectionUtils.isNotEmpty(aggregationConfigs) ? aggregationConfigs : null;
        this._maxLeafRecords = maxLeafRecords;
        Preconditions.checkArgument((this._functionColumnPairs != null || this._aggregationConfigs != null ? 1 : 0) != 0, (Object)"Either 'functionColumnPairs' or 'aggregationConfigs' must be configured");
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    @Nullable
    public List<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }

    @Nullable
    public List<String> getFunctionColumnPairs() {
        return this._functionColumnPairs;
    }

    @Nullable
    public List<StarTreeAggregationConfig> getAggregationConfigs() {
        return this._aggregationConfigs;
    }

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }
}

