/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class TimeFieldSpec
extends FieldSpec {
    private TimeGranularitySpec _incomingGranularitySpec;
    private TimeGranularitySpec _outgoingGranularitySpec;

    public TimeFieldSpec() {
    }

    public TimeFieldSpec(TimeGranularitySpec incomingGranularitySpec) {
        super(incomingGranularitySpec.getName(), incomingGranularitySpec.getDataType(), true);
        this._incomingGranularitySpec = incomingGranularitySpec;
    }

    public TimeFieldSpec(TimeGranularitySpec incomingGranularitySpec, TimeGranularitySpec outgoingGranularitySpec) {
        super(outgoingGranularitySpec.getName(), outgoingGranularitySpec.getDataType(), true);
        this._incomingGranularitySpec = incomingGranularitySpec;
        this._outgoingGranularitySpec = outgoingGranularitySpec;
    }

    @Override
    @JsonIgnore
    public FieldSpec.FieldType getFieldType() {
        return FieldSpec.FieldType.TIME;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setDataType(FieldSpec.DataType dataType) {
    }

    @Override
    public void setSingleValueField(boolean isSingleValueField) {
        Preconditions.checkArgument((boolean)isSingleValueField, (Object)"Unsupported multi-value for time field.");
    }

    public TimeGranularitySpec getIncomingGranularitySpec() {
        return this._incomingGranularitySpec;
    }

    public void setIncomingGranularitySpec(TimeGranularitySpec incomingGranularitySpec) {
        this._incomingGranularitySpec = incomingGranularitySpec;
        if (this._outgoingGranularitySpec == null) {
            super.setName(incomingGranularitySpec.getName());
            super.setDataType(incomingGranularitySpec.getDataType());
        }
    }

    public TimeGranularitySpec getOutgoingGranularitySpec() {
        if (this._outgoingGranularitySpec == null) {
            return this._incomingGranularitySpec;
        }
        return this._outgoingGranularitySpec;
    }

    public void setOutgoingGranularitySpec(TimeGranularitySpec outgoingGranularitySpec) {
        this._outgoingGranularitySpec = outgoingGranularitySpec;
        super.setName(outgoingGranularitySpec.getName());
        super.setDataType(outgoingGranularitySpec.getDataType());
    }

    @Override
    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.set("incomingGranularitySpec", (JsonNode)this._incomingGranularitySpec.toJsonObject());
        if (!this.getOutgoingGranularitySpec().equals(this._incomingGranularitySpec)) {
            jsonObject.set("outgoingGranularitySpec", (JsonNode)this._outgoingGranularitySpec.toJsonObject());
        }
        this.appendDefaultNullValue(jsonObject);
        this.appendTransformFunction(jsonObject);
        return jsonObject;
    }

    public String toString() {
        return "< field type: TIME, incoming granularity spec: " + this._incomingGranularitySpec + ", outgoing granularity spec: " + this.getOutgoingGranularitySpec() + ", default null value: " + this._defaultNullValue + " >";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TimeFieldSpec that = (TimeFieldSpec)o;
        return EqualityUtils.isEqual(this._incomingGranularitySpec, that._incomingGranularitySpec) && EqualityUtils.isEqual(this.getOutgoingGranularitySpec(), that.getOutgoingGranularitySpec());
    }

    @Override
    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(super.hashCode(), this._incomingGranularitySpec);
        result = EqualityUtils.hashCodeOf(result, this.getOutgoingGranularitySpec());
        return result;
    }
}

