/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderFactory;

public class RecordReaderFileConfig {
    public final FileFormat _fileFormat;
    public final File _dataFile;
    public final Set<String> _fieldsToRead;
    public final RecordReaderConfig _recordReaderConfig;
    private final boolean _isDelegateReader;
    public RecordReader _recordReader;
    private boolean _isRecordReaderInitialized;
    private boolean _isRecordReaderClosed;

    public RecordReaderFileConfig(FileFormat fileFormat, File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig, @Nullable RecordReader recordReader) {
        this._fileFormat = fileFormat;
        this._dataFile = dataFile;
        this._fieldsToRead = fieldsToRead;
        this._recordReaderConfig = recordReaderConfig;
        this._recordReader = recordReader;
        this._isDelegateReader = false;
        this._isRecordReaderInitialized = false;
        this._isRecordReaderClosed = false;
    }

    @Deprecated
    public RecordReaderFileConfig(RecordReader recordReader) {
        this._recordReader = recordReader;
        this._fileFormat = null;
        this._dataFile = null;
        this._fieldsToRead = null;
        this._recordReaderConfig = null;
        this._isDelegateReader = true;
        this._isRecordReaderInitialized = true;
        this._isRecordReaderClosed = false;
    }

    public RecordReader getRecordReader() throws Exception {
        if (!this._isRecordReaderInitialized) {
            if (this._recordReader == null) {
                this._recordReader = RecordReaderFactory.getRecordReader(this._fileFormat, this._dataFile, this._fieldsToRead, this._recordReaderConfig);
            } else {
                this._recordReader.init(this._dataFile, this._fieldsToRead, this._recordReaderConfig);
            }
            this._isRecordReaderInitialized = true;
        }
        return this._recordReader;
    }

    public void closeRecordReader() throws Exception {
        if (this._isRecordReaderInitialized && !this._isDelegateReader) {
            this._recordReader.close();
            this._isRecordReaderClosed = true;
        }
    }

    public boolean isRecordReaderDone() {
        if (this._isRecordReaderInitialized) {
            return !this._recordReader.hasNext();
        }
        return false;
    }

    public boolean isRecordReaderClosedFromRecordReaderFileConfig() {
        return this._isRecordReaderClosed;
    }
}

