/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import javax.annotation.Nullable;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.stream.StreamMessage;
import org.apache.pinot.spi.stream.StreamMessageMetadata;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface MessageBatch<T> {
    public int getMessageCount();

    default public int getUnfilteredMessageCount() {
        return this.getMessageCount();
    }

    default public StreamMessage<T> getStreamMessage(int index) {
        byte[] value = this.getMessageBytesAtIndex(index);
        StreamMessageMetadata metadata = (StreamMessageMetadata)this.getMetadataAtIndex(index);
        return new StreamMessage<byte[]>(value, value.length, metadata);
    }

    default public StreamPartitionMsgOffset getOffsetOfNextBatch() {
        return this.getNextStreamPartitionMsgOffsetAtIndex(this.getMessageCount() - 1);
    }

    @Nullable
    default public StreamPartitionMsgOffset getFirstMessageOffset() {
        int numMessages = this.getMessageCount();
        if (numMessages == 0) {
            return null;
        }
        StreamMessageMetadata firstMessageMetadata = this.getStreamMessage(0).getMetadata();
        return firstMessageMetadata != null ? firstMessageMetadata.getOffset() : null;
    }

    @Nullable
    default public StreamMessageMetadata getLastMessageMetadata() {
        int numMessages = this.getMessageCount();
        if (numMessages == 0) {
            return null;
        }
        return this.getStreamMessage(numMessages - 1).getMetadata();
    }

    default public boolean isEndOfPartitionGroup() {
        return false;
    }

    default public boolean hasDataLoss() {
        return false;
    }

    @Deprecated
    default public T getMessageAtIndex(int index) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public byte[] getMessageBytesAtIndex(int index) {
        return (byte[])this.getMessageAtIndex(index);
    }

    @Deprecated
    default public int getMessageLengthAtIndex(int index) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public int getMessageOffsetAtIndex(int index) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public RowMetadata getMetadataAtIndex(int index) {
        return null;
    }

    @Deprecated
    default public long getNextStreamMessageOffsetAtIndex(int index) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public StreamPartitionMsgOffset getNextStreamPartitionMsgOffsetAtIndex(int index) {
        return new LongMsgOffset(this.getNextStreamMessageOffsetAtIndex(index));
    }
}

