/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import com.google.common.base.Preconditions;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.TimeUtils;

public class OffsetCriteria {
    public static final OffsetCriteria SMALLEST_OFFSET_CRITERIA = new OffsetCriteriaBuilder().withOffsetSmallest();
    public static final OffsetCriteria LARGEST_OFFSET_CRITERIA = new OffsetCriteriaBuilder().withOffsetLargest();
    private OffsetType _offsetType;
    private String _offsetString;

    private OffsetCriteria() {
    }

    private void setOffsetType(OffsetType offsetType) {
        this._offsetType = offsetType;
    }

    private void setOffsetString(String offsetString) {
        this._offsetString = offsetString;
    }

    public boolean isSmallest() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.SMALLEST);
    }

    public boolean isLargest() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.LARGEST);
    }

    public boolean isPeriod() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.PERIOD);
    }

    public boolean isTimestamp() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.TIMESTAMP);
    }

    public boolean isCustom() {
        return this._offsetType != null && this._offsetType.equals((Object)OffsetType.CUSTOM);
    }

    public String getOffsetString() {
        return this._offsetString;
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        OffsetCriteria that = (OffsetCriteria)o;
        return EqualityUtils.isEqual((Object)this._offsetType, (Object)that._offsetType) && EqualityUtils.isEqual(this._offsetString, that._offsetString);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._offsetType);
        result = EqualityUtils.hashCodeOf(result, this._offsetString);
        return result;
    }

    public String toString() {
        return "OffsetCriteria{_offsetType=" + this._offsetType + ", _offsetString='" + this._offsetString + "'}";
    }

    public static class OffsetCriteriaBuilder {
        private OffsetCriteria _offsetCriteria = new OffsetCriteria();

        public OffsetCriteria withOffsetSmallest() {
            this._offsetCriteria.setOffsetType(OffsetType.SMALLEST);
            this._offsetCriteria.setOffsetString(OffsetType.SMALLEST.toString().toLowerCase());
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetLargest() {
            this._offsetCriteria.setOffsetType(OffsetType.LARGEST);
            this._offsetCriteria.setOffsetString(OffsetType.LARGEST.toString().toLowerCase());
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetAsPeriod(String periodString) {
            Preconditions.checkNotNull((Object)periodString, (Object)"Must provide period string eg. 10d, 4h30m etc");
            this._offsetCriteria.setOffsetType(OffsetType.PERIOD);
            this._offsetCriteria.setOffsetString(periodString);
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetAsTimestamp(String timestamp) {
            Preconditions.checkNotNull((Object)timestamp, (Object)"Must provide timestamp string of format yyyy-MM-dd'T'HH:mm:ss.SSSZ eg. 2022-08-09T12:31:38.222Z");
            this._offsetCriteria.setOffsetType(OffsetType.TIMESTAMP);
            this._offsetCriteria.setOffsetString(timestamp);
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetCustom(String customString) {
            Preconditions.checkNotNull((Object)customString, (Object)"Must provide custom offset criteria string");
            this._offsetCriteria.setOffsetType(OffsetType.CUSTOM);
            this._offsetCriteria.setOffsetString(customString);
            return this._offsetCriteria;
        }

        public OffsetCriteria withOffsetString(String offsetString) {
            Preconditions.checkNotNull((Object)offsetString, (Object)"Must provide offset string");
            if (offsetString.equalsIgnoreCase(OffsetType.SMALLEST.toString())) {
                this._offsetCriteria.setOffsetType(OffsetType.SMALLEST);
            } else if (offsetString.equalsIgnoreCase(OffsetType.LARGEST.toString())) {
                this._offsetCriteria.setOffsetType(OffsetType.LARGEST);
            } else if (TimeUtils.isPeriodValid(offsetString)) {
                long periodToMillis = TimeUtils.convertPeriodToMillis(offsetString);
                if (periodToMillis >= 0L) {
                    this._offsetCriteria.setOffsetType(OffsetType.PERIOD);
                } else {
                    this._offsetCriteria.setOffsetType(OffsetType.CUSTOM);
                }
            } else if (TimeUtils.isTimestampValid(offsetString)) {
                this._offsetCriteria.setOffsetType(OffsetType.TIMESTAMP);
            } else {
                this._offsetCriteria.setOffsetType(OffsetType.CUSTOM);
            }
            this._offsetCriteria.setOffsetString(offsetString);
            return this._offsetCriteria;
        }
    }

    private static enum OffsetType {
        SMALLEST,
        LARGEST,
        PERIOD,
        TIMESTAMP,
        CUSTOM;

    }
}

