/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;

public class StreamMessageMetadata
implements RowMetadata {
    private final long _recordIngestionTimeMs;
    private final long _firstStreamRecordIngestionTimeMs;
    private final StreamPartitionMsgOffset _offset;
    private final StreamPartitionMsgOffset _nextOffset;
    private final GenericRow _headers;
    private final Map<String, String> _metadata;

    @Deprecated
    public StreamMessageMetadata(long recordIngestionTimeMs) {
        this(recordIngestionTimeMs, null);
    }

    @Deprecated
    public StreamMessageMetadata(long recordIngestionTimeMs, @Nullable GenericRow headers) {
        this(recordIngestionTimeMs, headers, null);
    }

    @Deprecated
    public StreamMessageMetadata(long recordIngestionTimeMs, @Nullable GenericRow headers, Map<String, String> metadata) {
        this(recordIngestionTimeMs, Long.MIN_VALUE, headers, metadata);
    }

    @Deprecated
    public StreamMessageMetadata(long recordIngestionTimeMs, long firstStreamRecordIngestionTimeMs, @Nullable GenericRow headers, Map<String, String> metadata) {
        this(recordIngestionTimeMs, firstStreamRecordIngestionTimeMs, null, null, headers, metadata);
    }

    public StreamMessageMetadata(long recordIngestionTimeMs, long firstStreamRecordIngestionTimeMs, @Nullable StreamPartitionMsgOffset offset, @Nullable StreamPartitionMsgOffset nextOffset, @Nullable GenericRow headers, @Nullable Map<String, String> metadata) {
        this._recordIngestionTimeMs = recordIngestionTimeMs;
        this._firstStreamRecordIngestionTimeMs = firstStreamRecordIngestionTimeMs;
        this._offset = offset;
        this._nextOffset = nextOffset;
        this._headers = headers;
        this._metadata = metadata;
    }

    @Override
    public long getRecordIngestionTimeMs() {
        return this._recordIngestionTimeMs;
    }

    @Override
    public long getFirstStreamRecordIngestionTimeMs() {
        return this._firstStreamRecordIngestionTimeMs;
    }

    @Override
    @Nullable
    public StreamPartitionMsgOffset getOffset() {
        return this._offset;
    }

    @Override
    @Nullable
    public StreamPartitionMsgOffset getNextOffset() {
        return this._nextOffset;
    }

    @Override
    @Nullable
    public GenericRow getHeaders() {
        return this._headers;
    }

    @Override
    @Nullable
    public Map<String, String> getRecordMetadata() {
        return this._metadata;
    }

    public static class Builder {
        private long _recordIngestionTimeMs = Long.MIN_VALUE;
        private long _firstStreamRecordIngestionTimeMs = Long.MIN_VALUE;
        private StreamPartitionMsgOffset _offset;
        private StreamPartitionMsgOffset _nextOffset;
        private GenericRow _headers;
        private Map<String, String> _metadata;

        public Builder setRecordIngestionTimeMs(long recordIngestionTimeMs) {
            this._recordIngestionTimeMs = recordIngestionTimeMs;
            return this;
        }

        public Builder setFirstStreamRecordIngestionTimeMs(long firstStreamRecordIngestionTimeMs) {
            this._firstStreamRecordIngestionTimeMs = firstStreamRecordIngestionTimeMs;
            return this;
        }

        public Builder setOffset(StreamPartitionMsgOffset offset, StreamPartitionMsgOffset nextOffset) {
            this._offset = offset;
            this._nextOffset = nextOffset;
            return this;
        }

        public Builder setHeaders(GenericRow headers) {
            this._headers = headers;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this._metadata = metadata;
            return this;
        }

        public StreamMessageMetadata build() {
            return new StreamMessageMetadata(this._recordIngestionTimeMs, this._firstStreamRecordIngestionTimeMs, this._offset, this._nextOffset, this._headers, this._metadata);
        }
    }
}

