/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.google.common.collect.Interner;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;

public class FALFInterner<T>
implements Interner<T> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private final Object[] _cache;
    private final int _cacheLengthMinusOne;
    private final BiPredicate<T, T> _equalsFunction;
    private final ToIntFunction<T> _hashFunction;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;

    public FALFInterner(int expectedCapacity) {
        this(expectedCapacity, Objects::hashCode);
    }

    public FALFInterner(int expectedCapacity, ToIntFunction<T> hashFunction) {
        this(expectedCapacity, hashFunction, Objects::equals);
    }

    public FALFInterner(int expectedCapacity, ToIntFunction<T> hashFunction, BiPredicate<T, T> equalsFunction) {
        this._cache = new Object[FALFInterner.tableSizeFor(expectedCapacity)];
        this._cacheLengthMinusOne = this._cache.length - 1;
        this._equalsFunction = Objects.requireNonNull(equalsFunction);
        this._hashFunction = Objects.requireNonNull(hashFunction);
    }

    public T intern(T obj) {
        int slot = this.hash(obj) & this._cacheLengthMinusOne;
        Object cachedObj = this._cache[slot];
        if (cachedObj != null && this._equalsFunction.test(obj, cachedObj)) {
            return (T)cachedObj;
        }
        this._cache[slot] = obj;
        return obj;
    }

    private int hash(T key) {
        int h = this._hashFunction.applyAsInt(key);
        return h ^ h >>> 16;
    }

    private static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public static int hashCode(String s) {
        int h1 = 0;
        for (int i = 1; i < s.length(); i += 2) {
            int k1 = s.charAt(i - 1) | s.charAt(i) << 16;
            h1 = FALFInterner.nextHashCode(k1, h1);
        }
        if ((s.length() & 1) == 1) {
            int k1 = s.charAt(s.length() - 1);
            k1 = FALFInterner.mixK1(k1);
            h1 ^= k1;
        }
        return FALFInterner.fmix(h1, s.length() * 2);
    }

    private static int nextHashCode(int value, int prevHashCode) {
        int k1 = FALFInterner.mixK1(value);
        return FALFInterner.mixH1(prevHashCode, k1);
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int len) {
        h1 ^= len;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

