/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3Location;
import io.trino.filesystem.s3.S3OutputStream;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import software.amazon.awssdk.services.s3.S3Client;

final class S3OutputFile
implements TrinoOutputFile {
    private final Executor uploadExecutor;
    private final S3Client client;
    private final S3Context context;
    private final S3Location location;
    private final Optional<EncryptionKey> key;

    public S3OutputFile(Executor uploadExecutor, S3Client client, S3Context context, S3Location location, Optional<EncryptionKey> key) {
        this.uploadExecutor = Objects.requireNonNull(uploadExecutor, "uploadExecutor is null");
        this.client = Objects.requireNonNull(client, "client is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.key = Objects.requireNonNull(key, "key is null");
        location.location().verifyValidFileLocation();
    }

    public void createOrOverwrite(byte[] data) throws IOException {
        try (OutputStream out = this.create(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), false);){
            out.write(data);
        }
    }

    public void createExclusive(byte[] data) throws IOException {
        if (!this.context.exclusiveWriteSupported()) {
            throw new UnsupportedOperationException("createExclusive not supported by " + String.valueOf(this.getClass()));
        }
        try (OutputStream out = this.create(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), true);){
            out.write(data);
        }
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) {
        return this.create(memoryContext, this.context.exclusiveWriteSupported());
    }

    public OutputStream create(AggregatedMemoryContext memoryContext, boolean exclusive) {
        return new S3OutputStream(memoryContext, this.uploadExecutor, this.client, this.context, this.location, exclusive, this.key);
    }

    public Location location() {
        return this.location.location();
    }
}

