/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.direct;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import io.opentelemetry.api.trace.Span;
import io.trino.SystemSessionProperties;
import io.trino.dispatcher.DispatchManager;
import io.trino.dispatcher.DispatchQuery;
import io.trino.exchange.DirectExchangeInput;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.execution.buffer.CompressionCodec;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.operator.DirectExchangeClient;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.server.SessionContext;
import io.trino.server.protocol.Slug;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.type.Type;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.intellij.lang.annotations.Language;

public class DirectTrinoClient {
    private final DispatchManager dispatchManager;
    private final QueryManager queryManager;
    private final DirectExchangeClientSupplier directExchangeClientSupplier;
    private final BlockEncodingSerde blockEncodingSerde;

    public DirectTrinoClient(DispatchManager dispatchManager, QueryManager queryManager, DirectExchangeClientSupplier directExchangeClientSupplier, BlockEncodingSerde blockEncodingSerde) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.directExchangeClientSupplier = Objects.requireNonNull(directExchangeClientSupplier, "directExchangeClientSupplier is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
    }

    public DispatchQuery execute(SessionContext sessionContext, @Language(value="SQL") String sql, QueryResultsListener queryResultsListener) {
        QueryId queryId = this.dispatchManager.createQueryId();
        DirectTrinoClient.getQueryFuture(this.dispatchManager.createQuery(queryId, Span.getInvalid(), Slug.createNew(), sessionContext, sql));
        DirectTrinoClient.getQueryFuture(this.dispatchManager.waitForDispatched(queryId));
        DispatchQuery dispatchQuery = this.dispatchManager.getQuery(queryId);
        if (dispatchQuery.getState().isDone()) {
            return dispatchQuery;
        }
        try (DirectExchangeClient exchangeClient = this.createExchangeClient(dispatchQuery);){
            this.queryManager.setOutputInfoListener(queryId, outputInfo -> {
                DirectTrinoClient directTrinoClient = this;
                synchronized (directTrinoClient) {
                    queryResultsListener.setOutputColumns(outputInfo.getColumnNames(), outputInfo.getColumnTypes());
                    outputInfo.drainInputs(input -> {
                        DirectExchangeInput exchangeInput = (DirectExchangeInput)input;
                        exchangeClient.addLocation(exchangeInput.getTaskId(), URI.create(exchangeInput.getLocation()));
                    });
                    if (outputInfo.isNoMoreInputs()) {
                        exchangeClient.noMoreLocations();
                    }
                }
            });
            PageDeserializer pageDeserializer = new PagesSerdeFactory(this.blockEncodingSerde, CompressionCodec.NONE).createDeserializer(Optional.empty());
            QueryState state = this.queryManager.getQueryState(queryId);
            while (!(state == QueryState.FAILED || exchangeClient.isFinished() || dispatchQuery.getState() == QueryState.FINISHING && dispatchQuery.getFullQueryInfo().getOutputStage().isEmpty())) {
                Slice serializedPage = exchangeClient.pollPage();
                while (serializedPage != null) {
                    Page page = pageDeserializer.deserialize(serializedPage);
                    queryResultsListener.consumeOutputPage(page);
                    serializedPage = exchangeClient.pollPage();
                }
                DirectTrinoClient.getQueryFuture(MoreFutures.whenAnyComplete((Iterable)ImmutableList.of(this.queryManager.getStateChange(queryId, state), exchangeClient.isBlocked())));
                state = this.queryManager.getQueryState(queryId);
            }
        }
        this.queryManager.resultsConsumed(queryId);
        QueryState queryState = this.queryManager.getQueryState(queryId);
        while (!queryState.isDone()) {
            DirectTrinoClient.getQueryFuture(this.queryManager.getStateChange(queryId, queryState));
            queryState = this.queryManager.getQueryState(queryId);
        }
        return dispatchQuery;
    }

    private DirectExchangeClient createExchangeClient(DispatchQuery dispatchQuery) {
        return this.directExchangeClientSupplier.get(dispatchQuery.getQueryId(), new ExchangeId("direct-exchange-query-results"), Span.current(), (LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "Query"), this.queryManager::outputTaskFailed, SystemSessionProperties.getRetryPolicy(dispatchQuery.getSession()));
    }

    private static <T> void getQueryFuture(ListenableFuture<T> future) {
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Thread interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error processing query", e.getCause());
        }
    }

    public static interface QueryResultsListener {
        public void setOutputColumns(List<String> var1, List<Type> var2);

        public void consumeOutputPage(Page var1);
    }
}

