/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.cost.RuntimeInfoProvider;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimator;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.PlanFragmentId;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StaticRuntimeInfoProvider
implements RuntimeInfoProvider {
    private final Map<PlanFragmentId, OutputStatsEstimator.OutputStatsEstimateResult> runtimeOutputStats;
    private final Map<PlanFragmentId, PlanFragment> planFragments;

    public StaticRuntimeInfoProvider(Map<PlanFragmentId, OutputStatsEstimator.OutputStatsEstimateResult> runtimeOutputStats, Map<PlanFragmentId, PlanFragment> planFragments) {
        this.runtimeOutputStats = ImmutableMap.copyOf(Objects.requireNonNull(runtimeOutputStats, "runtimeOutputStats is null"));
        this.planFragments = ImmutableMap.copyOf(Objects.requireNonNull(planFragments, "planFragments is null"));
    }

    @Override
    public OutputStatsEstimator.OutputStatsEstimateResult getRuntimeOutputStats(PlanFragmentId planFragmentId) {
        return this.runtimeOutputStats.getOrDefault(planFragmentId, OutputStatsEstimator.OutputStatsEstimateResult.unknown());
    }

    @Override
    public PlanFragment getPlanFragment(PlanFragmentId planFragmentId) {
        PlanFragment planFragment = this.planFragments.get(planFragmentId);
        Objects.requireNonNull(planFragment, "planFragment must not be null: %s".formatted(planFragmentId));
        return planFragment;
    }

    @Override
    public List<PlanFragment> getAllPlanFragments() {
        return ImmutableList.copyOf(this.planFragments.values());
    }
}

