/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CommentTask
implements DataDefinitionTask<Comment> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public CommentTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "COMMENT";
    }

    @Override
    public ListenableFuture<Void> execute(Comment statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        if (statement.getType() == Comment.Type.TABLE) {
            this.commentOnTable(statement, session);
        } else if (statement.getType() == Comment.Type.VIEW) {
            this.commentOnView(statement, session);
        } else if (statement.getType() == Comment.Type.COLUMN) {
            this.commentOnColumn(statement, session);
        } else {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Unsupported comment type: %s", statement.getType());
        }
        return Futures.immediateVoidFuture();
    }

    private void commentOnTable(Comment statement, Session session) {
        QualifiedObjectName originalTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        if (this.metadata.isMaterializedView(session, originalTableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist, but a materialized view with that name exists. Setting comments on materialized views is unsupported.", originalTableName);
        }
        if (this.metadata.isView(session, originalTableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%1$s' does not exist, but a view with that name exists. Did you mean COMMENT ON VIEW %1$s IS ...?", originalTableName);
        }
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, originalTableName);
        if (redirectionAwareTableHandle.tableHandle().isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: %s", originalTableName);
        }
        this.accessControl.checkCanSetTableComment(session.toSecurityContext(), redirectionAwareTableHandle.redirectedTableName().orElse(originalTableName));
        TableHandle tableHandle = redirectionAwareTableHandle.tableHandle().get();
        this.metadata.setTableComment(session, tableHandle, statement.getComment());
    }

    private void commentOnView(Comment statement, Session session) {
        QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        if (!this.metadata.isView(session, viewName)) {
            Object additionalInformation = this.metadata.getMaterializedView(session, viewName).isPresent() ? ", but a materialized view with that name exists. Setting comments on materialized views is unsupported." : (this.metadata.getTableHandle(session, viewName).isPresent() ? ", but a table with that name exists. Did you mean COMMENT ON TABLE " + String.valueOf(viewName) + " IS ...?" : "");
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist%s", viewName, additionalInformation);
        }
        this.accessControl.checkCanSetViewComment(session.toSecurityContext(), viewName);
        this.metadata.setViewComment(session, viewName, statement.getComment());
    }

    private void commentOnColumn(Comment statement, Session session) {
        QualifiedName prefix = (QualifiedName)statement.getName().getPrefix().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_TABLE, (Node)statement, "Table must be specified", new Object[0]));
        QualifiedObjectName originalObjectName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, prefix);
        Optional<ViewDefinition> view = this.metadata.getView(session, originalObjectName);
        if (view.isPresent()) {
            ViewDefinition viewDefinition = view.get();
            ViewColumn viewColumn = this.findAndCheckViewColumn(statement, session, viewDefinition, originalObjectName);
            this.metadata.setViewColumnComment(session, originalObjectName, viewColumn.name(), statement.getComment());
        } else if (this.metadata.isMaterializedView(session, originalObjectName)) {
            MaterializedViewDefinition materializedViewDefinition = this.metadata.getMaterializedView(session, originalObjectName).get();
            ViewColumn viewColumn = this.findAndCheckViewColumn(statement, session, materializedViewDefinition, originalObjectName);
            this.metadata.setMaterializedViewColumnComment(session, originalObjectName, viewColumn.name(), statement.getComment());
        } else {
            RedirectionAwareTableHandle redirectionAwareTableHandle = this.metadata.getRedirectionAwareTableHandle(session, originalObjectName);
            if (redirectionAwareTableHandle.tableHandle().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: %s", originalObjectName);
            }
            TableHandle tableHandle = redirectionAwareTableHandle.tableHandle().get();
            String columnName = statement.getName().getSuffix();
            Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(session, tableHandle);
            if (!columnHandles.containsKey(columnName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column does not exist: %s", columnName);
            }
            this.accessControl.checkCanSetColumnComment(session.toSecurityContext(), redirectionAwareTableHandle.redirectedTableName().orElse(originalObjectName));
            this.metadata.setColumnComment(session, tableHandle, columnHandles.get(columnName), statement.getComment());
        }
    }

    private ViewColumn findAndCheckViewColumn(Comment statement, Session session, ViewDefinition viewDefinition, QualifiedObjectName originalObjectName) {
        String columnName = statement.getName().getSuffix();
        ViewColumn viewColumn = viewDefinition.getColumns().stream().filter(column -> column.name().equals(columnName)).findAny().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column does not exist: %s", columnName));
        this.accessControl.checkCanSetColumnComment(session.toSecurityContext(), originalObjectName);
        return viewColumn;
    }
}

