/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.execution.TaskId;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.LanguageFunctionAnalysisException;
import io.trino.metadata.LanguageFunctionDefinition;
import io.trino.metadata.LanguageFunctionEngineManager;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.metadata.PropertyUtil;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.security.AccessControl;
import io.trino.security.ViewAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.function.LanguageFunctionEngine;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.Identity;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlFormatter;
import io.trino.sql.SqlPath;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.routine.SqlRoutineAnalysis;
import io.trino.sql.routine.SqlRoutineAnalyzer;
import io.trino.sql.routine.SqlRoutineCompiler;
import io.trino.sql.routine.SqlRoutineHash;
import io.trino.sql.routine.SqlRoutinePlanner;
import io.trino.sql.routine.ir.IrRoutine;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.ParameterDeclaration;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.StringLiteral;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class LanguageFunctionManager
implements LanguageFunctionProvider {
    public static final String QUERY_LOCAL_SCHEMA = "$query";
    private static final String SQL_FUNCTION_PREFIX = "$trino_sql_";
    private final SqlParser parser;
    private final TypeManager typeManager;
    private final GroupProvider groupProvider;
    private final BlockEncodingSerde blockEncodingSerde;
    private final LanguageFunctionEngineManager engineManager;
    private PlannerContext plannerContext;
    private SqlRoutineAnalyzer analyzer;
    private SqlRoutinePlanner planner;
    private final Map<QueryId, QueryFunctions> queryFunctions = new ConcurrentHashMap<QueryId, QueryFunctions>();

    @Inject
    public LanguageFunctionManager(SqlParser parser, TypeManager typeManager, GroupProvider groupProvider, BlockEncodingSerde blockEncodingSerde, LanguageFunctionEngineManager engineManager) {
        this.parser = Objects.requireNonNull(parser, "parser is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.engineManager = Objects.requireNonNull(engineManager, "engineManager is null");
    }

    public synchronized void setPlannerContext(PlannerContext plannerContext) {
        Preconditions.checkState((this.plannerContext == null ? 1 : 0) != 0, (Object)"plannerContext already set");
        this.plannerContext = plannerContext;
        this.analyzer = new SqlRoutineAnalyzer(plannerContext, WarningCollector.NOOP);
        this.planner = new SqlRoutinePlanner(plannerContext);
    }

    public void tryRegisterQuery(Session session) {
        this.queryFunctions.putIfAbsent(session.getQueryId(), new QueryFunctions(session));
    }

    public void registerQuery(Session session) {
        boolean alreadyRegistered;
        boolean bl = alreadyRegistered = this.queryFunctions.putIfAbsent(session.getQueryId(), new QueryFunctions(session)) != null;
        if (alreadyRegistered) {
            throw new IllegalStateException("Query already registered: " + String.valueOf(session.getQueryId()));
        }
    }

    public void unregisterQuery(Session session) {
        this.queryFunctions.remove(session.getQueryId());
    }

    @Override
    public void registerTask(TaskId taskId, Map<FunctionId, LanguageFunctionProvider.LanguageFunctionData> languageFunctions) {
    }

    @Override
    public void unregisterTask(TaskId taskId) {
    }

    private QueryFunctions getQueryFunctions(Session session) {
        QueryFunctions queryFunctions = this.queryFunctions.get(session.getQueryId());
        if (queryFunctions == null) {
            throw new IllegalStateException("Query not registered: " + String.valueOf(session.getQueryId()));
        }
        return queryFunctions;
    }

    public List<FunctionMetadata> listFunctions(Session session, Collection<LanguageFunction> languageFunctions) {
        return (List)languageFunctions.stream().map(LanguageFunction::sql).map(sql -> SqlRoutineAnalyzer.extractFunctionMetadata(LanguageFunctionManager.createSqlLanguageFunctionId(session.getQueryId(), sql), this.parser.createFunctionSpecification(sql))).collect(ImmutableList.toImmutableList());
    }

    public List<FunctionMetadata> getFunctions(Session session, CatalogHandle catalogHandle, SchemaFunctionName name, LanguageFunctionLoader languageFunctionLoader, RunAsIdentityLoader identityLoader) {
        return this.getQueryFunctions(session).getFunctions(catalogHandle, name, languageFunctionLoader, identityLoader);
    }

    public FunctionMetadata getFunctionMetadata(Session session, FunctionId functionId) {
        return this.getQueryFunctions(session).getFunctionMetadata(functionId);
    }

    public FunctionId analyzeAndPlan(Session session, FunctionId functionId, AccessControl accessControl) {
        return this.getQueryFunctions(session).analyzeAndPlan(functionId, accessControl);
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionId functionId, InvocationConvention invocationConvention, FunctionManager functionManager) {
        return this.queryFunctions.values().stream().map(queryFunctions -> queryFunctions.specialize(functionId, invocationConvention, functionManager)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new IllegalStateException("Unknown function implementation: " + String.valueOf(functionId)));
    }

    public Map<FunctionId, LanguageFunctionProvider.LanguageFunctionData> serializeFunctionsForWorkers(Session session) {
        return this.getQueryFunctions(session).serializeFunctionsForWorkers();
    }

    public void verifyForCreate(Session session, FunctionSpecification function, FunctionManager functionManager, AccessControl accessControl) {
        this.getQueryFunctions(session).verifyForCreate(function, functionManager, accessControl);
    }

    public void addInlineFunction(Session session, FunctionSpecification function, AccessControl accessControl) {
        this.getQueryFunctions(session).addInlineFunction(function, accessControl);
    }

    public static boolean isInlineFunction(CatalogSchemaFunctionName functionName) {
        return functionName.getCatalogName().equals("system") && functionName.getSchemaName().equals(QUERY_LOCAL_SCHEMA);
    }

    public static boolean isTrinoSqlLanguageFunction(FunctionId functionId) {
        return functionId.toString().startsWith(SQL_FUNCTION_PREFIX);
    }

    private static FunctionId createSqlLanguageFunctionId(QueryId queryId, String sql) {
        String hash = Hashing.sha256().hashUnencodedChars((CharSequence)sql).toString();
        return new FunctionId(SQL_FUNCTION_PREFIX + String.valueOf(queryId) + "_" + hash);
    }

    public String getSignatureToken(List<ParameterDeclaration> parameters) {
        return parameters.stream().map(ParameterDeclaration::getType).map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).map(Type::getTypeId).map(TypeId::getId).collect(Collectors.joining(",", "(", ")"));
    }

    public List<Property> materializeFunctionProperties(Session session, FunctionSpecification function, Map<NodeRef<Parameter>, Expression> parameters, AccessControl accessControl) {
        LanguageFunctionEngine engine = this.getLanguageFunctionEngine(function);
        return PropertyUtil.toSqlProperties("function language " + engine.getLanguage(), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_PROPERTY, this.evaluateFunctionProperties(session, function, parameters, accessControl), engine.getFunctionProperties());
    }

    private Map<String, Object> evaluateFunctionProperties(Session session, FunctionSpecification function, Map<NodeRef<Parameter>, Expression> parameters, AccessControl accessControl) {
        LanguageFunctionEngine engine = this.getLanguageFunctionEngine(function);
        Map<String, Optional<Object>> nullableValues = PropertyUtil.evaluateProperties(SqlRoutineAnalyzer.getProperties(function), session, this.plannerContext, accessControl, parameters, true, Maps.uniqueIndex((Iterable)engine.getFunctionProperties(), PropertyMetadata::getName), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_PROPERTY, "function language %s property".formatted(engine.getLanguage()));
        return (Map)nullableValues.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).orElseThrow()));
    }

    private LanguageFunctionEngine getLanguageFunctionEngine(FunctionSpecification function) {
        String language = SqlRoutineAnalyzer.getLanguageName(function);
        return this.engineManager.getLanguageFunctionEngine(language).orElseThrow(() -> {
            Node node = SqlRoutineAnalyzer.getLanguage(function).map(Node.class::cast).orElse((Node)function);
            return SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, node, "Unsupported function language: %s", language);
        });
    }

    private class QueryFunctions {
        private final Session session;
        private final Map<FunctionKey, FunctionListing> functionListing = new ConcurrentHashMap<FunctionKey, FunctionListing>();
        private final Map<FunctionId, LanguageFunctionImplementation> implementationsById = new ConcurrentHashMap<FunctionId, LanguageFunctionImplementation>();
        private final Map<FunctionId, LanguageFunctionProvider.LanguageFunctionData> usedFunctions = new ConcurrentHashMap<FunctionId, LanguageFunctionProvider.LanguageFunctionData>();

        public QueryFunctions(Session session) {
            this.session = session;
        }

        public void verifyForCreate(FunctionSpecification function, FunctionManager functionManager, AccessControl accessControl) {
            this.implementationWithoutSecurity(this.session.getQueryId(), function).verifyForCreate(functionManager, accessControl);
        }

        public void addInlineFunction(FunctionSpecification function, AccessControl accessControl) {
            LanguageFunctionImplementation implementation = this.implementationWithoutSecurity(this.session.getQueryId(), function);
            FunctionMetadata metadata = implementation.getFunctionMetadata();
            this.implementationsById.put(metadata.getFunctionId(), implementation);
            SchemaFunctionName name = new SchemaFunctionName(LanguageFunctionManager.QUERY_LOCAL_SCHEMA, metadata.getCanonicalName());
            this.getFunctionListing(GlobalSystemConnector.CATALOG_HANDLE, name).addFunction(metadata);
            implementation.analyzeAndPlan(accessControl);
        }

        public synchronized List<FunctionMetadata> getFunctions(CatalogHandle catalogHandle, SchemaFunctionName name, LanguageFunctionLoader languageFunctionLoader, RunAsIdentityLoader identityLoader) {
            return this.getFunctionListing(catalogHandle, name).getFunctions(languageFunctionLoader, identityLoader);
        }

        public FunctionId analyzeAndPlan(FunctionId functionId, AccessControl accessControl) {
            LanguageFunctionImplementation function = this.implementationsById.get(functionId);
            Preconditions.checkArgument((function != null ? 1 : 0) != 0, (String)"Unknown function implementation: %s", (Object)functionId);
            function.analyzeAndPlan(accessControl);
            LanguageFunctionProvider.LanguageFunctionData data = function.getFunctionData();
            FunctionId resolvedFunctionId = function.getResolvedFunctionId();
            this.usedFunctions.put(resolvedFunctionId, data);
            return resolvedFunctionId;
        }

        public Optional<ScalarFunctionImplementation> specialize(FunctionId functionId, InvocationConvention invocationConvention, FunctionManager functionManager) {
            LanguageFunctionProvider.LanguageFunctionData data = this.usedFunctions.get(functionId);
            if (data == null) {
                return Optional.empty();
            }
            if (data.definition().isPresent()) {
                LanguageFunctionDefinition definition = data.definition().get();
                LanguageFunctionEngine engine = LanguageFunctionManager.this.engineManager.getLanguageFunctionEngine(definition.language()).orElseThrow(() -> new IllegalStateException("No language function engine for language: " + definition.language()));
                return Optional.of(engine.getScalarFunctionImplementation(definition.returnType(), definition.argumentTypes(), definition.definition(), definition.properties(), invocationConvention));
            }
            IrRoutine routine = data.irRoutine().orElseThrow();
            SpecializedSqlScalarFunction function = new SqlRoutineCompiler(functionManager).compile(routine);
            return Optional.of(function.getScalarFunctionImplementation(invocationConvention));
        }

        public FunctionMetadata getFunctionMetadata(FunctionId functionId) {
            LanguageFunctionImplementation function = this.implementationsById.get(functionId);
            Preconditions.checkArgument((function != null ? 1 : 0) != 0, (String)"Unknown function implementation: %s", (Object)functionId);
            return function.getFunctionMetadata();
        }

        public Map<FunctionId, LanguageFunctionProvider.LanguageFunctionData> serializeFunctionsForWorkers() {
            return ImmutableMap.copyOf(this.usedFunctions);
        }

        private FunctionListing getFunctionListing(CatalogHandle catalogHandle, SchemaFunctionName name) {
            return this.functionListing.computeIfAbsent(new FunctionKey(catalogHandle, name), x$0 -> new FunctionListing((FunctionKey)x$0));
        }

        private LanguageFunctionImplementation implementationWithoutSecurity(QueryId queryId, FunctionSpecification function) {
            return new LanguageFunctionImplementation(queryId, SqlFormatter.formatSql((Node)function), function, this.session.getPath(), Optional.empty(), Optional.empty());
        }

        private LanguageFunctionImplementation implementationWithSecurity(QueryId queryId, String sql, List<CatalogSchemaName> path, Optional<String> owner, RunAsIdentityLoader identityLoader) {
            return new LanguageFunctionImplementation(queryId, sql, LanguageFunctionManager.this.parser.createFunctionSpecification(sql), this.session.getPath().forView(path), owner, Optional.of(identityLoader));
        }

        private class LanguageFunctionImplementation {
            private final FunctionMetadata functionMetadata;
            private final FunctionSpecification functionSpecification;
            private final SqlPath path;
            private final Optional<String> owner;
            private final Optional<RunAsIdentityLoader> identityLoader;
            private final String language;
            private final boolean engineFunction;
            private LanguageFunctionProvider.LanguageFunctionData data;
            private IrRoutine routine;
            private FunctionId resolvedFunctionId;
            private boolean analyzing;

            private LanguageFunctionImplementation(QueryId queryId, String sql, FunctionSpecification function, SqlPath path, Optional<String> owner, Optional<RunAsIdentityLoader> identityLoader) {
                this.functionSpecification = Objects.requireNonNull(function, "function is null");
                this.functionMetadata = SqlRoutineAnalyzer.extractFunctionMetadata(LanguageFunctionManager.createSqlLanguageFunctionId(queryId, sql), this.functionSpecification);
                this.path = Objects.requireNonNull(path, "path is null");
                this.owner = Objects.requireNonNull(owner, "owner is null");
                this.identityLoader = Objects.requireNonNull(identityLoader, "identityLoader is null");
                this.language = SqlRoutineAnalyzer.getLanguageName(function);
                this.engineFunction = !this.language.equalsIgnoreCase("SQL");
            }

            public FunctionMetadata getFunctionMetadata() {
                return this.functionMetadata;
            }

            public synchronized void verifyForCreate(FunctionManager functionManager, AccessControl accessControl) {
                Preconditions.checkState((boolean)this.identityLoader.isEmpty(), (Object)"create should not enforce security");
                this.analyzeAndPlan(accessControl);
                if (!this.engineFunction) {
                    new SqlRoutineCompiler(functionManager).compile(this.routine);
                }
            }

            private synchronized void analyzeAndPlan(AccessControl accessControl) {
                if (this.data != null) {
                    return;
                }
                if (this.engineFunction) {
                    this.data = LanguageFunctionProvider.LanguageFunctionData.ofDefinition(this.analyzeEngineFunction(this.functionContext(accessControl)));
                    this.resolvedFunctionId = this.functionMetadata.getFunctionId();
                    return;
                }
                if (this.analyzing) {
                    String error = "Recursive language functions are not supported: " + this.nameSignature();
                    if (this.originalAst()) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, ExpressionTreeUtils.extractLocation((Node)this.functionSpecification), error, null);
                    }
                    throw new LanguageFunctionAnalysisException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, error);
                }
                this.analyzing = true;
                SqlRoutineAnalysis analysis = this.analyzeSqlFunction(this.functionContext(accessControl));
                this.routine = LanguageFunctionManager.this.planner.planSqlFunction(QueryFunctions.this.session, analysis);
                this.data = LanguageFunctionProvider.LanguageFunctionData.ofIrRoutine(this.routine);
                Hasher hasher = Hashing.sha256().newHasher();
                SqlRoutineHash.hash(this.routine, hasher, LanguageFunctionManager.this.blockEncodingSerde);
                this.resolvedFunctionId = new FunctionId(LanguageFunctionManager.SQL_FUNCTION_PREFIX + String.valueOf(hasher.hash()));
                this.analyzing = false;
            }

            private SqlRoutineAnalysis analyzeSqlFunction(FunctionContext context) {
                try {
                    return LanguageFunctionManager.this.analyzer.analyze(context.session(), context.accessControl(), this.functionSpecification);
                }
                catch (TrinoException e) {
                    if (this.originalAst() || e instanceof LanguageFunctionAnalysisException) {
                        throw e;
                    }
                    if (e.getErrorCode().getType() == ErrorType.USER_ERROR) {
                        throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), e.getRawMessage(), (Throwable)e);
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Error analyzing stored function: " + this.nameSignature(), (Throwable)e);
                }
            }

            private LanguageFunctionDefinition analyzeEngineFunction(FunctionContext context) {
                LanguageFunctionDefinition definition = this.engineFunctionDefinition(context);
                this.validateEngineFunction(definition);
                return definition;
            }

            private LanguageFunctionDefinition engineFunctionDefinition(FunctionContext context) {
                Type returnType = LanguageFunctionManager.this.typeManager.getType(this.functionMetadata.getSignature().getReturnType());
                List argumentTypes = (List)this.functionMetadata.getSignature().getArgumentTypes().stream().map(arg_0 -> ((TypeManager)LanguageFunctionManager.this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
                String definition = ((StringLiteral)this.functionSpecification.getDefinition().orElseThrow()).getValue();
                Map<String, Object> properties = this.engineFunctionProperties(context);
                return new LanguageFunctionDefinition(this.language, returnType, argumentTypes, definition, properties);
            }

            private Map<String, Object> engineFunctionProperties(FunctionContext context) {
                try {
                    return LanguageFunctionManager.this.evaluateFunctionProperties(context.session(), this.functionSpecification, Map.of(), context.accessControl());
                }
                catch (TrinoException e) {
                    if (this.originalAst()) {
                        throw e;
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Error analyzing stored function: " + this.nameSignature(), (Throwable)e);
                }
            }

            private void validateEngineFunction(LanguageFunctionDefinition definition) {
                try {
                    LanguageFunctionEngine engine = LanguageFunctionManager.this.getLanguageFunctionEngine(this.functionSpecification);
                    engine.validateScalarFunction(definition.returnType(), definition.argumentTypes(), definition.definition(), definition.properties());
                }
                catch (TrinoException e) {
                    if (this.originalAst()) {
                        String message = "Invalid function '%s': %s".formatted(this.functionMetadata.getCanonicalName(), e.getMessage());
                        throw new TrinoException(() -> ((TrinoException)e).getErrorCode(), ExpressionTreeUtils.extractLocation((Node)this.functionSpecification), message, (Throwable)e);
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Error validating stored function: " + this.nameSignature(), (Throwable)e);
                }
            }

            private String nameSignature() {
                return this.functionMetadata.getCanonicalName() + String.valueOf(this.functionMetadata.getSignature());
            }

            public synchronized LanguageFunctionProvider.LanguageFunctionData getFunctionData() {
                Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"function not yet analyzed");
                return this.data;
            }

            public synchronized FunctionId getResolvedFunctionId() {
                Preconditions.checkState((this.resolvedFunctionId != null ? 1 : 0) != 0, (Object)"function not yet analyzed");
                return this.resolvedFunctionId;
            }

            private FunctionContext functionContext(AccessControl accessControl) {
                if (this.identityLoader.isEmpty() || SqlRoutineAnalyzer.isRunAsInvoker(this.functionSpecification)) {
                    Session functionSession = this.createFunctionSession(QueryFunctions.this.session.getIdentity());
                    return new FunctionContext(functionSession, accessControl);
                }
                Identity identity = this.identityLoader.get().getFunctionRunAsIdentity(this.owner);
                Identity newIdentity = Identity.from((Identity)identity).withGroups(LanguageFunctionManager.this.groupProvider.getGroups(identity.getUser())).build();
                Session functionSession = this.createFunctionSession(newIdentity);
                if (!identity.getUser().equals(QueryFunctions.this.session.getUser())) {
                    accessControl = new ViewAccessControl(accessControl);
                }
                return new FunctionContext(functionSession, accessControl);
            }

            private Session createFunctionSession(Identity identity) {
                return QueryFunctions.this.session.createViewSession(Optional.empty(), Optional.empty(), identity, this.path);
            }

            private boolean originalAst() {
                return this.identityLoader.isEmpty();
            }

            private record FunctionContext(Session session, AccessControl accessControl) {
            }
        }

        private class FunctionListing {
            private final CatalogHandle catalogHandle;
            private final SchemaFunctionName name;
            private final List<FunctionMetadata> functions = new ArrayList<FunctionMetadata>();
            private boolean loaded;

            public FunctionListing(FunctionKey key) {
                this.catalogHandle = key.catalogHandle();
                this.name = key.name();
            }

            public synchronized void addFunction(FunctionMetadata function) {
                this.functions.add(function);
                this.loaded = true;
            }

            public synchronized List<FunctionMetadata> getFunctions(LanguageFunctionLoader languageFunctionLoader, RunAsIdentityLoader identityLoader) {
                if (this.loaded) {
                    return ImmutableList.copyOf(this.functions);
                }
                this.loaded = true;
                List implementations = (List)languageFunctionLoader.getLanguageFunction(QueryFunctions.this.session.toConnectorSession(), this.name).stream().map(function -> QueryFunctions.this.implementationWithSecurity(QueryFunctions.this.session.getQueryId(), function.sql(), function.path(), function.owner(), identityLoader)).collect(ImmutableList.toImmutableList());
                Set names = (Set)implementations.stream().map(function -> function.getFunctionMetadata().getCanonicalName()).collect(ImmutableSet.toImmutableSet());
                if (!names.isEmpty() && !names.equals(Set.of(this.name.getFunctionName()))) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Catalog %s returned functions named %s when listing functions named %s".formatted(this.catalogHandle.getCatalogName(), names, this.name));
                }
                implementations.forEach(implementation -> this.functions.add(implementation.getFunctionMetadata()));
                implementations.forEach(processedFunction -> QueryFunctions.this.implementationsById.put(processedFunction.getFunctionMetadata().getFunctionId(), (LanguageFunctionImplementation)processedFunction));
                return ImmutableList.copyOf(this.functions);
            }
        }

        private record FunctionKey(CatalogHandle catalogHandle, SchemaFunctionName name) {
        }
    }

    public static interface LanguageFunctionLoader {
        public Collection<LanguageFunction> getLanguageFunction(ConnectorSession var1, SchemaFunctionName var2);
    }

    public static interface RunAsIdentityLoader {
        public Identity getFunctionRunAsIdentity(Optional<String> var1);
    }
}

