/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.node.NodeInfo;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.trino.FeaturesConfig;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.TaskFailureListener;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DeduplicatingDirectExchangeBuffer;
import io.trino.operator.DirectExchangeBuffer;
import io.trino.operator.DirectExchangeClient;
import io.trino.operator.DirectExchangeClientConfig;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.operator.ForExchange;
import io.trino.operator.RetryPolicy;
import io.trino.operator.StreamingDirectExchangeBuffer;
import io.trino.spi.QueryId;
import io.trino.spi.exchange.ExchangeId;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DirectExchangeClientFactory
implements DirectExchangeClientSupplier {
    private final NodeInfo nodeInfo;
    private final FeaturesConfig.DataIntegrityVerification dataIntegrityVerification;
    private final DataSize maxBufferedBytes;
    private final DataSize deduplicationBufferSize;
    private final int concurrentRequestMultiplier;
    private final Duration maxErrorDuration;
    private final HttpClient httpClient;
    private final DataSize maxResponseSize;
    private final boolean acknowledgePages;
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutorMBean executorMBean;
    private final ExecutorService pageBufferClientCallbackExecutor;
    private final ExchangeManagerRegistry exchangeManagerRegistry;

    @Inject
    public DirectExchangeClientFactory(NodeInfo nodeInfo, FeaturesConfig featuresConfig, DirectExchangeClientConfig config, @ForExchange HttpClient httpClient, @ForExchange HttpClientConfig httpClientConfig, @ForExchange ScheduledExecutorService scheduler, ExchangeManagerRegistry exchangeManagerRegistry) {
        this(nodeInfo, featuresConfig.getExchangeDataIntegrityVerification(), config.getMaxBufferSize(), config.getDeduplicationBufferSize(), config.getMaxResponseSize(), httpClientConfig.getMaxContentLength(), config.getConcurrentRequestMultiplier(), config.getMaxErrorDuration(), config.isAcknowledgePages(), config.getPageBufferClientMaxCallbackThreads(), httpClient, scheduler, exchangeManagerRegistry);
    }

    public DirectExchangeClientFactory(NodeInfo nodeInfo, FeaturesConfig.DataIntegrityVerification dataIntegrityVerification, DataSize maxBufferedBytes, DataSize deduplicationBufferSize, DataSize maxResponseSize, DataSize maxClientResponseSize, int concurrentRequestMultiplier, Duration maxErrorDuration, boolean acknowledgePages, int pageBufferClientMaxCallbackThreads, HttpClient httpClient, ScheduledExecutorService scheduler, ExchangeManagerRegistry exchangeManagerRegistry) {
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.dataIntegrityVerification = Objects.requireNonNull(dataIntegrityVerification, "dataIntegrityVerification is null");
        this.maxBufferedBytes = Objects.requireNonNull(maxBufferedBytes, "maxBufferedBytes is null");
        this.deduplicationBufferSize = Objects.requireNonNull(deduplicationBufferSize, "deduplicationBufferSize is null");
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.maxErrorDuration = Objects.requireNonNull(maxErrorDuration, "maxErrorDuration is null");
        this.acknowledgePages = acknowledgePages;
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(maxResponseSize, "maxResponseSize is null");
        long maxResponseSizeBytes = (long)((double)Math.min(maxClientResponseSize.toBytes(), maxResponseSize.toBytes()) * 0.75);
        this.maxResponseSize = DataSize.ofBytes((long)maxResponseSizeBytes);
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler is null");
        this.pageBufferClientCallbackExecutor = Executors.newFixedThreadPool(pageBufferClientMaxCallbackThreads, Threads.daemonThreadsNamed((String)"page-buffer-client-callback-%s"));
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.pageBufferClientCallbackExecutor);
        Preconditions.checkArgument((maxBufferedBytes.toBytes() > 0L ? 1 : 0) != 0, (String)"maxBufferSize must be at least 1 byte: %s", (Object)maxBufferedBytes);
        Preconditions.checkArgument((maxResponseSize.toBytes() > 0L ? 1 : 0) != 0, (String)"maxResponseSize must be at least 1 byte: %s", (Object)maxResponseSize);
        Preconditions.checkArgument((concurrentRequestMultiplier > 0 ? 1 : 0) != 0, (String)"concurrentRequestMultiplier must be at least 1: %s", (int)concurrentRequestMultiplier);
        this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
    }

    @PreDestroy
    public void stop() {
        this.pageBufferClientCallbackExecutor.shutdownNow();
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Override
    public DirectExchangeClient get(QueryId queryId, ExchangeId exchangeId, Span parentSpan, LocalMemoryContext memoryContext, TaskFailureListener taskFailureListener, RetryPolicy retryPolicy) {
        DirectExchangeBuffer buffer = switch (retryPolicy) {
            default -> throw new MatchException(null, null);
            case RetryPolicy.TASK -> throw new UnsupportedOperationException();
            case RetryPolicy.QUERY -> new DeduplicatingDirectExchangeBuffer(this.scheduler, this.deduplicationBufferSize, retryPolicy, this.exchangeManagerRegistry, queryId, parentSpan, exchangeId);
            case RetryPolicy.NONE -> new StreamingDirectExchangeBuffer(this.scheduler, this.maxBufferedBytes);
        };
        return new DirectExchangeClient(this.nodeInfo.getExternalAddress(), this.dataIntegrityVerification, buffer, this.maxResponseSize, this.concurrentRequestMultiplier, this.maxErrorDuration, this.acknowledgePages, this.httpClient, this.scheduler, memoryContext, this.pageBufferClientCallbackExecutor, taskFailureListener);
    }
}

