/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.HashArraySizeSupplier;
import it.unimi.dsi.fastutil.HashCommon;

public class IncrementalLoadFactorHashArraySizeSupplier
implements HashArraySizeSupplier {
    public static final int THRESHOLD_25 = 65536;
    public static final int THRESHOLD_50 = 0x100000;
    private final int multiplier;

    public IncrementalLoadFactorHashArraySizeSupplier(int multiplier) {
        this.multiplier = multiplier;
    }

    @Override
    public int getHashArraySize(int expectedCount) {
        if (expectedCount <= 65536 * this.multiplier) {
            return HashCommon.arraySize((int)expectedCount, (float)0.25f);
        }
        if (expectedCount <= 0x100000 * this.multiplier) {
            return HashCommon.arraySize((int)expectedCount, (float)0.5f);
        }
        return HashCommon.arraySize((int)expectedCount, (float)0.75f);
    }
}

