/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OperatorInfo;
import io.trino.operator.PageBuffer;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorFactory;
import io.trino.operator.join.JoinOperatorFactory;
import io.trino.spi.Page;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class WorkProcessorOperatorAdapter
implements Operator {
    private final OperatorContext operatorContext;
    private final WorkProcessor<Page> pages;
    private final PageBuffer pageBuffer = new PageBuffer();
    private final WorkProcessorOperator workProcessorOperator;

    public static OperatorFactory createAdapterOperatorFactory(WorkProcessorOperatorFactory operatorFactory) {
        return new Factory(operatorFactory);
    }

    public WorkProcessorOperatorAdapter(OperatorContext operatorContext, WorkProcessorOperatorFactory workProcessorOperatorFactory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        MemoryTrackingContext memoryTrackingContext = new MemoryTrackingContext(operatorContext.aggregateUserMemoryContext(), operatorContext.aggregateRevocableMemoryContext());
        memoryTrackingContext.initializeLocalMemoryContexts(workProcessorOperatorFactory.getOperatorType());
        this.workProcessorOperator = workProcessorOperatorFactory.create(new ProcessorContext(operatorContext.getSession(), memoryTrackingContext, operatorContext), this.pageBuffer.pages());
        this.pages = this.workProcessorOperator.getOutputPages();
        operatorContext.setInfoSupplier(WorkProcessorOperatorAdapter.createInfoSupplier(this.workProcessorOperator));
    }

    private static Supplier<OperatorInfo> createInfoSupplier(WorkProcessorOperator workProcessorOperator) {
        return () -> workProcessorOperator.getOperatorInfo().orElse(null);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (!this.pages.isBlocked()) {
            return NOT_BLOCKED;
        }
        return this.pages.getBlockedFuture();
    }

    @Override
    public boolean needsInput() {
        return !this.pages.isBlocked() && !this.pages.isFinished() && this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.pageBuffer.add(page);
    }

    @Override
    public Page getOutput() {
        if (!this.pages.process()) {
            this.updateOperatorMetrics();
            return null;
        }
        if (this.pages.isFinished()) {
            this.updateOperatorMetrics();
            return null;
        }
        this.updateOperatorMetrics();
        return this.pages.getResult();
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    @Override
    public boolean isFinished() {
        return this.pages.isFinished();
    }

    @Override
    public void close() throws Exception {
        this.workProcessorOperator.close();
    }

    private void updateOperatorMetrics() {
        this.operatorContext.setLatestMetrics(this.workProcessorOperator.getMetrics());
    }

    @VisibleForTesting
    public static class Factory
    implements OperatorFactory,
    JoinOperatorFactory {
        private final WorkProcessorOperatorFactory operatorFactory;

        Factory(WorkProcessorOperatorFactory operatorFactory) {
            this.operatorFactory = Objects.requireNonNull(operatorFactory, "operatorFactory is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorFactory.getOperatorId(), this.operatorFactory.getPlanNodeId(), this.operatorFactory.getOperatorType());
            return new WorkProcessorOperatorAdapter(operatorContext, this.operatorFactory);
        }

        @Override
        public void noMoreOperators() {
            this.operatorFactory.close();
        }

        @Override
        public OperatorFactory duplicate() {
            return new Factory(this.operatorFactory.duplicate());
        }

        @Override
        public Optional<OperatorFactory> createOuterOperatorFactory() {
            WorkProcessorOperatorFactory workProcessorOperatorFactory = this.operatorFactory;
            if (!(workProcessorOperatorFactory instanceof JoinOperatorFactory)) {
                return Optional.empty();
            }
            JoinOperatorFactory lookupJoin = (JoinOperatorFactory)((Object)workProcessorOperatorFactory);
            return lookupJoin.createOuterOperatorFactory();
        }

        @VisibleForTesting
        public WorkProcessorOperatorFactory getWorkProcessorOperatorFactory() {
            return this.operatorFactory;
        }
    }
}

