/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.annotations;

import io.trino.metadata.FunctionBinding;
import io.trino.metadata.SignatureBinder;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.type.TypeSignature;
import java.util.Objects;

public final class TypeImplementationDependency
implements ImplementationDependency {
    private final TypeSignature signature;

    public TypeImplementationDependency(TypeSignature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
    }

    public TypeSignature getSignature() {
        return this.signature;
    }

    @Override
    public void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder) {
        builder.addType(this.signature);
    }

    @Override
    public Object resolve(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        return functionDependencies.getType(SignatureBinder.applyBoundVariables(this.signature, functionBinding));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeImplementationDependency that = (TypeImplementationDependency)o;
        return Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }
}

