/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;

public class SelectedPositions {
    private static final SelectedPositions EMPTY = SelectedPositions.positionsRange(0, 0);
    private final boolean isList;
    private final int[] positions;
    private final int offset;
    private final int size;

    public static SelectedPositions positionsList(int[] positions, int offset, int size) {
        return new SelectedPositions(true, positions, offset, size);
    }

    public static SelectedPositions positionsRange(int offset, int size) {
        return new SelectedPositions(false, new int[0], offset, size);
    }

    private SelectedPositions(boolean isList, int[] positions, int offset, int size) {
        this.isList = isList;
        this.positions = Objects.requireNonNull(positions, "positions is null");
        this.offset = offset;
        this.size = size;
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset is negative");
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size is negative");
        if (isList) {
            Preconditions.checkPositionIndexes((int)offset, (int)(offset + size), (int)positions.length);
        }
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int[] getPositions() {
        Preconditions.checkState((boolean)this.isList, (Object)"SelectedPositions is a range");
        return this.positions;
    }

    public int getOffset() {
        return this.offset;
    }

    public int size() {
        return this.size;
    }

    public SelectedPositions subRange(int start, int end) {
        Preconditions.checkPositionIndexes((int)start, (int)end, (int)this.size);
        int newOffset = this.offset + start;
        int newLength = end - start;
        return new SelectedPositions(this.isList, this.positions, newOffset, newLength);
    }

    public SelectedPositions difference(SelectedPositions otherPositions) {
        if (this.isEmpty() || otherPositions.isEmpty()) {
            return this;
        }
        int resultPositionsCount = 0;
        if (this.isList && otherPositions.isList()) {
            int[] result = new int[this.size];
            int currentIndex = this.offset;
            int endIndex = this.offset + this.size;
            int currentPosition = this.positions[currentIndex];
            int[] otherPositionsList = otherPositions.getPositions();
            int otherCurrentIndex = otherPositions.getOffset();
            int otherEndIndex = otherPositions.getOffset() + otherPositions.size();
            int otherCurrentPosition = otherPositionsList[otherCurrentIndex];
            while (true) {
                if (currentPosition < otherCurrentPosition) {
                    result[resultPositionsCount++] = currentPosition;
                    if (++currentIndex >= endIndex) break;
                    currentPosition = this.positions[currentIndex];
                    continue;
                }
                if (currentPosition == otherCurrentPosition) {
                    if (++currentIndex >= endIndex) break;
                    currentPosition = this.positions[currentIndex];
                }
                if (++otherCurrentIndex >= otherEndIndex) {
                    resultPositionsCount = SelectedPositions.copyList(this.positions, currentIndex, endIndex, result, resultPositionsCount);
                    return SelectedPositions.positionsList(result, 0, resultPositionsCount);
                }
                otherCurrentPosition = otherPositionsList[otherCurrentIndex];
            }
            return SelectedPositions.positionsList(result, 0, resultPositionsCount);
        }
        if (!this.isList && otherPositions.isList()) {
            int[] result = new int[this.size];
            int currentPosition = this.offset;
            int endPosition = this.offset + this.size;
            int[] otherPositionsList = otherPositions.getPositions();
            int otherCurrentIndex = otherPositions.getOffset();
            int otherEndIndex = otherPositions.getOffset() + otherPositions.size();
            int otherCurrentPosition = otherPositionsList[otherCurrentIndex];
            while (true) {
                if (currentPosition < otherCurrentPosition) {
                    result[resultPositionsCount++] = currentPosition++;
                    if (currentPosition < endPosition) continue;
                    break;
                }
                if (currentPosition == otherCurrentPosition && ++currentPosition >= endPosition) break;
                if (++otherCurrentIndex >= otherEndIndex) {
                    resultPositionsCount = SelectedPositions.copyRange(currentPosition, endPosition, result, resultPositionsCount);
                    return SelectedPositions.positionsList(result, 0, resultPositionsCount);
                }
                otherCurrentPosition = otherPositionsList[otherCurrentIndex];
            }
            return SelectedPositions.positionsList(result, 0, resultPositionsCount);
        }
        if (this.isList && !otherPositions.isList()) {
            int[] result;
            block19: {
                result = new int[this.size];
                int currentIndex = this.offset;
                int endIndex = this.offset + this.size;
                int currentPosition = this.positions[currentIndex];
                int otherCurrentPosition = otherPositions.getOffset();
                int otherEndPosition = otherPositions.getOffset() + otherPositions.size();
                while (true) {
                    if (currentPosition < otherCurrentPosition) {
                        result[resultPositionsCount++] = currentPosition;
                        if (++currentIndex < endIndex) {
                            currentPosition = this.positions[currentIndex];
                            continue;
                        }
                        break block19;
                    }
                    if (currentPosition == otherCurrentPosition) {
                        if (++currentIndex >= endIndex) break block19;
                        currentPosition = this.positions[currentIndex];
                    }
                    if (++otherCurrentPosition >= otherEndPosition) break;
                }
                resultPositionsCount = SelectedPositions.copyList(this.positions, currentIndex, endIndex, result, resultPositionsCount);
                return SelectedPositions.positionsList(result, 0, resultPositionsCount);
            }
            return SelectedPositions.positionsList(result, 0, resultPositionsCount);
        }
        Verify.verify((!this.isList && !otherPositions.isList() ? 1 : 0) != 0);
        int endPosition = this.offset + this.size;
        int otherEndPosition = otherPositions.getOffset() + otherPositions.size();
        if (!SelectedPositions.overlaps(this.offset, this.size, otherPositions.getOffset(), otherPositions.size())) {
            return this;
        }
        if (this.offset < otherPositions.getOffset()) {
            if (endPosition <= otherEndPosition) {
                return SelectedPositions.positionsRange(this.offset, otherPositions.getOffset() - this.offset);
            }
            int[] result = new int[this.size - otherPositions.size()];
            resultPositionsCount = SelectedPositions.copyRange(this.offset, otherPositions.getOffset(), result, resultPositionsCount);
            resultPositionsCount = SelectedPositions.copyRange(otherEndPosition, endPosition, result, resultPositionsCount);
            return SelectedPositions.positionsList(result, 0, resultPositionsCount);
        }
        if (otherEndPosition < endPosition) {
            return SelectedPositions.positionsRange(otherEndPosition, endPosition - otherEndPosition);
        }
        return EMPTY;
    }

    public SelectedPositions union(SelectedPositions otherPositions) {
        if (otherPositions.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return otherPositions;
        }
        if (this.isList && otherPositions.isList()) {
            int[] result = new int[this.size + otherPositions.size()];
            int resultPositionsCount = 0;
            int currentIndex = this.offset;
            int endIndex = this.offset + this.size;
            int currentPosition = this.positions[currentIndex];
            int[] otherPositionsList = otherPositions.getPositions();
            int otherCurrentIndex = otherPositions.getOffset();
            int otherEndIndex = otherPositions.getOffset() + otherPositions.size();
            int otherCurrentPosition = otherPositionsList[otherCurrentIndex];
            while (true) {
                if (currentPosition < otherCurrentPosition) {
                    result[resultPositionsCount++] = currentPosition;
                    if (++currentIndex >= endIndex) {
                        resultPositionsCount = SelectedPositions.copyList(otherPositionsList, otherCurrentIndex, otherEndIndex, result, resultPositionsCount);
                        return SelectedPositions.positionsList(result, 0, resultPositionsCount);
                    }
                    currentPosition = this.positions[currentIndex];
                    continue;
                }
                if (currentPosition == otherCurrentPosition) {
                    result[resultPositionsCount++] = currentPosition;
                    ++otherCurrentIndex;
                    if (++currentIndex >= endIndex) {
                        resultPositionsCount = SelectedPositions.copyList(otherPositionsList, otherCurrentIndex, otherEndIndex, result, resultPositionsCount);
                        return SelectedPositions.positionsList(result, 0, resultPositionsCount);
                    }
                    if (otherCurrentIndex >= otherEndIndex) {
                        resultPositionsCount = SelectedPositions.copyList(this.positions, currentIndex, endIndex, result, resultPositionsCount);
                        return SelectedPositions.positionsList(result, 0, resultPositionsCount);
                    }
                    currentPosition = this.positions[currentIndex];
                    otherCurrentPosition = otherPositionsList[otherCurrentIndex];
                    continue;
                }
                result[resultPositionsCount++] = otherCurrentPosition;
                if (++otherCurrentIndex >= otherEndIndex) {
                    resultPositionsCount = SelectedPositions.copyList(this.positions, currentIndex, endIndex, result, resultPositionsCount);
                    return SelectedPositions.positionsList(result, 0, resultPositionsCount);
                }
                otherCurrentPosition = otherPositionsList[otherCurrentIndex];
            }
        }
        if (!this.isList && otherPositions.isList()) {
            return SelectedPositions.union(this.offset, this.size, otherPositions.getPositions(), otherPositions.getOffset(), otherPositions.size());
        }
        if (this.isList && !otherPositions.isList()) {
            return SelectedPositions.union(otherPositions.getOffset(), otherPositions.size(), this.positions, this.offset, this.size);
        }
        Verify.verify((!this.isList && !otherPositions.isList() ? 1 : 0) != 0);
        int otherOffset = otherPositions.getOffset();
        int otherSize = otherPositions.size();
        if (SelectedPositions.overlaps(this.offset, this.size, otherOffset, otherSize)) {
            int endOffset = Math.max(this.offset + this.size, otherOffset + otherSize);
            int startOffset = Math.min(this.offset, otherOffset);
            return SelectedPositions.positionsRange(startOffset, endOffset - startOffset);
        }
        int[] result = new int[this.size + otherPositions.size()];
        int resultPositionsCount = 0;
        if (this.offset < otherOffset) {
            resultPositionsCount = SelectedPositions.copyRange(this.offset, this.offset + this.size, result, resultPositionsCount);
            resultPositionsCount = SelectedPositions.copyRange(otherOffset, otherOffset + otherSize, result, resultPositionsCount);
        } else {
            resultPositionsCount = SelectedPositions.copyRange(otherOffset, otherOffset + otherSize, result, resultPositionsCount);
            resultPositionsCount = SelectedPositions.copyRange(this.offset, this.offset + this.size, result, resultPositionsCount);
        }
        return SelectedPositions.positionsList(result, 0, resultPositionsCount);
    }

    private static SelectedPositions union(int rangeStart, int rangeSize, int[] positions, int offset, int size) {
        int[] result = new int[rangeSize + size];
        int resultPositionsCount = 0;
        int rangeEndPosition = rangeStart + rangeSize;
        int rangeCurrentPosition = rangeStart;
        int listCurrentIndex = offset;
        int listEndIndex = offset + size;
        int listCurrentPosition = positions[listCurrentIndex];
        while (true) {
            if (rangeCurrentPosition < listCurrentPosition) {
                result[resultPositionsCount++] = rangeCurrentPosition++;
                if (rangeCurrentPosition < rangeEndPosition) continue;
                resultPositionsCount = SelectedPositions.copyList(positions, listCurrentIndex, listEndIndex, result, resultPositionsCount);
                return SelectedPositions.positionsList(result, 0, resultPositionsCount);
            }
            if (rangeCurrentPosition == listCurrentPosition) {
                result[resultPositionsCount++] = rangeCurrentPosition++;
                ++listCurrentIndex;
                if (rangeCurrentPosition >= rangeEndPosition) {
                    resultPositionsCount = SelectedPositions.copyList(positions, listCurrentIndex, listEndIndex, result, resultPositionsCount);
                    return SelectedPositions.positionsList(result, 0, resultPositionsCount);
                }
                if (listCurrentIndex >= listEndIndex) {
                    resultPositionsCount = SelectedPositions.copyRange(rangeCurrentPosition, rangeEndPosition, result, resultPositionsCount);
                    return SelectedPositions.positionsList(result, 0, resultPositionsCount);
                }
                listCurrentPosition = positions[listCurrentIndex];
                continue;
            }
            result[resultPositionsCount++] = listCurrentPosition;
            if (++listCurrentIndex >= listEndIndex) {
                resultPositionsCount = SelectedPositions.copyRange(rangeCurrentPosition, rangeEndPosition, result, resultPositionsCount);
                return SelectedPositions.positionsList(result, 0, resultPositionsCount);
            }
            listCurrentPosition = positions[listCurrentIndex];
        }
    }

    private static int copyRange(int rangeStart, int rangeEnd, int[] result, int offset) {
        Objects.checkFromIndexSize(offset, rangeEnd - rangeStart, result.length);
        while (rangeStart < rangeEnd) {
            result[offset++] = rangeStart++;
        }
        return offset;
    }

    private static int copyList(int[] positions, int startIndex, int endIndex, int[] result, int offset) {
        int remainingLength = endIndex - startIndex;
        System.arraycopy(positions, startIndex, result, offset, remainingLength);
        return offset + remainingLength;
    }

    private static boolean overlaps(int leftOffset, int leftSize, int rightOffset, int rightSize) {
        return SelectedPositions.isNotFullyBefore(leftOffset + leftSize, rightOffset) && SelectedPositions.isNotFullyBefore(rightOffset + rightSize, leftOffset);
    }

    private static boolean isNotFullyBefore(int leftHigh, int rightLow) {
        return leftHigh >= rightLow;
    }
}

