/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.BlockSet;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;

@ScalarFunction(value="array_distinct")
@Description(value="Remove duplicate values from the given array")
public final class ArrayDistinctFunction {
    public static final String NAME = "array_distinct";
    private final BufferedArrayValueBuilder arrayValueBuilder;

    @TypeParameter(value="E")
    public ArrayDistinctFunction(@TypeParameter(value="E") Type elementType) {
        this.arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType(elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block distinct(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IDENTICAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsIdentical elementIdentical, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode elementHashCode, @SqlType(value="array(E)") Block array) {
        if (array.getPositionCount() < 2) {
            return array;
        }
        if (array.getPositionCount() == 2) {
            boolean identical = elementIdentical.isIdentical(array, 0, array, 1);
            if (!identical) {
                return array;
            }
            return array.getSingleValueBlock(0);
        }
        BlockSet distinctElements = new BlockSet(type, elementIdentical, elementHashCode, array.getPositionCount());
        for (int i = 0; i < array.getPositionCount(); ++i) {
            distinctElements.add(array, i);
        }
        return this.arrayValueBuilder.build(distinctElements.size(), blockBuilder -> distinctElements.getAllWithSizeLimit(blockBuilder, NAME, BlockSet.MAX_FUNCTION_MEMORY));
    }

    @SqlType(value="array(bigint)")
    public Block bigintDistinct(@SqlType(value="array(bigint)") Block array) {
        if (array.getPositionCount() == 0) {
            return array;
        }
        return this.arrayValueBuilder.build(array.getPositionCount(), distinctElementBlockBuilder -> {
            boolean containsNull = false;
            LongOpenHashSet set = new LongOpenHashSet(array.getPositionCount());
            for (int i = 0; i < array.getPositionCount(); ++i) {
                if (array.isNull(i)) {
                    if (containsNull) continue;
                    containsNull = true;
                    distinctElementBlockBuilder.appendNull();
                    continue;
                }
                long value = BigintType.BIGINT.getLong(array, i);
                if (!set.add(value)) continue;
                BigintType.BIGINT.writeLong(distinctElementBlockBuilder, value);
            }
        });
    }
}

