/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.trino.client.FailureInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.io.InputStream;

public final class FailureFunction {
    private static final JsonCodec<FailureInfo> JSON_CODEC = JsonCodec.jsonCodec(FailureInfo.class);

    private FailureFunction() {
    }

    @Description(value="Decodes json to an exception and throws it")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static boolean failWithException(@SqlType(value="json") Slice failureInfoSlice) {
        FailureInfo failureInfo = (FailureInfo)JSON_CODEC.fromJson((InputStream)failureInfoSlice.getInput());
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)failureInfo.toException());
    }

    @Description(value="Throws an exception with a given message")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static boolean fail(@SqlType(value="varchar") Slice message) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, message.toStringUtf8());
    }

    @Description(value="Throws an exception with a given error code and message")
    @ScalarFunction(value="fail", hidden=true)
    @SqlType(value="unknown")
    public static boolean fail(@SqlType(value="integer") long errorCode, @SqlType(value="varchar") Slice message) {
        for (StandardErrorCode standardErrorCode : StandardErrorCode.values()) {
            if ((long)standardErrorCode.toErrorCode().getCode() != errorCode) continue;
            throw new TrinoException((ErrorCodeSupplier)standardErrorCode, message.toStringUtf8());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unable to find error for code: " + errorCode);
    }
}

