/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.time;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.time.TimeOperators;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.type.DateTimes;
import java.util.Locale;

public class TimeFunctions {
    private TimeFunctions() {
    }

    @Description(value="Millisecond of the second of the given time")
    @ScalarFunction(value="millisecond")
    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long millisecond(@SqlType(value="time(p)") long time) {
        return time / 1000000000L % 1000L;
    }

    @Description(value="Second of the minute of the given time")
    @ScalarFunction(value="second")
    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long second(@SqlType(value="time(p)") long time) {
        return time / 1000000000000L % 60L;
    }

    @Description(value="Minute of the hour of the given time")
    @ScalarFunction(value="minute")
    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long minute(@SqlType(value="time(p)") long time) {
        return time / 60000000000000L % 60L;
    }

    @Description(value="Hour of the day of the given time")
    @ScalarFunction(value="hour")
    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long hour(@SqlType(value="time(p)") long time) {
        return time / 3600000000000000L;
    }

    @Description(value="Truncate to the specified precision")
    @ScalarFunction(value="date_trunc")
    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p)")
    public static long truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time(p)") long time) {
        String unitString;
        return switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond" -> time / 1000000000L * 1000000000L;
            case "second" -> time / 1000000000000L * 1000000000000L;
            case "minute" -> time / 60000000000000L * 60000000000000L;
            case "hour" -> time / 3600000000000000L * 3600000000000000L;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid TIME field");
        };
    }

    @Description(value="Add the specified amount of time to the given time")
    @LiteralParameters(value={"x", "p"})
    @ScalarFunction(value="date_add")
    @SqlType(value="time(p)")
    public static long dateAdd(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time(p)") long time) {
        String unitString;
        long delta = switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond" -> value % 86400000L * 1000000000L;
            case "second" -> value % 86400L * 1000000000000L;
            case "minute" -> value % 1440L * 60000000000000L;
            case "hour" -> value % 24L * 3600000000000000L;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid TIME field");
        };
        long result = TimeOperators.add(time, delta);
        if (precision <= 3L) {
            return DateTimes.round(result, (int)(12L - precision)) % 86400000000000000L;
        }
        return result;
    }

    @Description(value="Difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long dateDiff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time(p)") long time1, @SqlType(value="time(p)") long time2) {
        String unitString;
        long delta = time2 - time1;
        return switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond" -> delta / 1000000000L;
            case "second" -> delta / 1000000000000L;
            case "minute" -> delta / 60000000000000L;
            case "hour" -> delta / 3600000000000000L;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid TIME field");
        };
    }
}

