/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import java.time.Instant;

@ScalarFunction(value="$current_timestamp", hidden=true)
public final class CurrentTimestamp {
    private CurrentTimestamp() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long shortTimestamp(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="timestamp(p) with time zone") Long dummy) {
        Instant start = session.getStart();
        long epochMillis = start.toEpochMilli();
        if (precision < 3L) {
            epochMillis = DateTimes.round(epochMillis, (int)(3L - precision));
        } else {
            long nanosOfMilli = start.getNano() % 1000000;
            if (DateTimes.roundToNearest(nanosOfMilli, 1000000L) == 1000000L) {
                ++epochMillis;
            }
        }
        return DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)session.getTimeZoneKey());
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone longTimestamp(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone dummy) {
        Instant start = session.getStart();
        return DateTimes.longTimestampWithTimeZone(precision, start, session.getTimeZoneKey());
    }
}

