/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.timetz.TimeWithTimeZoneOperators;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimeWithTimeZone;
import java.util.Locale;

@Description(value="Difference of the given times in the given unit")
@ScalarFunction(value="date_diff")
public class DateDiff {
    private DateDiff() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
        String unitString;
        long nanos = TimeWithTimeZoneOperators.normalize(right) - TimeWithTimeZoneOperators.normalize(left);
        return switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond" -> nanos / 1000000L;
            case "second" -> nanos / 1000000000L;
            case "minute" -> nanos / 60000000000L;
            case "hour" -> nanos / 3600000000000L;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid TIME field");
        };
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
        String unitString;
        long picos = TimeWithTimeZoneOperators.normalize(right) - TimeWithTimeZoneOperators.normalize(left);
        return switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond" -> picos / 1000000000L;
            case "second" -> picos / 1000000000000L;
            case "minute" -> picos / 60000000000000L;
            case "hour" -> picos / 3600000000000000L;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid TIME field");
        };
    }
}

