/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table.json.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.table.json.execution.JsonTableProcessingFragment;
import io.trino.spi.Page;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FragmentCross
implements JsonTableProcessingFragment {
    private final List<JsonTableProcessingFragment> siblings;
    private final int[] outputLayout;
    private Page input;
    private int position;
    private JsonNode currentItem;
    private int currentSiblingIndex;

    public FragmentCross(List<JsonTableProcessingFragment> siblings) {
        this.siblings = ImmutableList.copyOf(siblings);
        Preconditions.checkArgument((siblings.size() >= 2 ? 1 : 0) != 0, (Object)"less than 2 siblings in Cross node");
        this.outputLayout = siblings.stream().map(JsonTableProcessingFragment::getOutputLayout).flatMapToInt(Arrays::stream).toArray();
    }

    @Override
    public void reset(JsonNode item, Page input, int position) {
        this.currentItem = Objects.requireNonNull(item, "item is null");
        this.input = Objects.requireNonNull(input, "input is null");
        this.position = position;
        this.siblings.get(0).reset(item, input, position);
        this.currentSiblingIndex = 0;
    }

    @Override
    public boolean getRow() {
        while (this.currentSiblingIndex >= 0) {
            boolean currentSiblingProducedRow = this.siblings.get(this.currentSiblingIndex).getRow();
            if (currentSiblingProducedRow) {
                for (int i = this.currentSiblingIndex + 1; i < this.siblings.size(); ++i) {
                    JsonTableProcessingFragment sibling = this.siblings.get(i);
                    sibling.reset(this.currentItem, this.input, this.position);
                    boolean siblingProducedRow = sibling.getRow();
                    if (siblingProducedRow) continue;
                    return false;
                }
                this.currentSiblingIndex = this.siblings.size() - 1;
                return true;
            }
            --this.currentSiblingIndex;
        }
        return false;
    }

    @Override
    public int[] getOutputLayout() {
        return this.outputLayout;
    }
}

