/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table.json.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.trino.json.JsonPathEvaluator;
import io.trino.json.ir.IrJsonPath;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.operator.table.json.execution.Column;
import io.trino.operator.table.json.execution.JsonTableProcessingFragment;
import io.trino.operator.table.json.execution.SequenceEvaluator;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.TypeManager;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public class FragmentSingle
implements JsonTableProcessingFragment {
    private static final Object[] NO_PARAMETERS = new Object[0];
    private final JsonPathEvaluator pathEvaluator;
    private final List<Column> columns;
    private final boolean errorOnError;
    private final boolean outer;
    private final JsonTableProcessingFragment child;
    private final int[] outputLayout;
    private final Object[] newRow;
    private Page input;
    private int position;
    private List<JsonNode> sequence;
    private int nextItemIndex;
    private boolean processNextItem;
    private boolean childAlreadyProduced;

    public FragmentSingle(IrJsonPath path, List<Column> columns, boolean errorOnError, boolean outer, JsonTableProcessingFragment child, Object[] newRow, ConnectorSession session, Metadata metadata, TypeManager typeManager, FunctionManager functionManager) {
        Objects.requireNonNull(path, "path is null");
        this.pathEvaluator = new JsonPathEvaluator(path, session, metadata, typeManager, functionManager);
        this.columns = ImmutableList.copyOf(columns);
        this.errorOnError = errorOnError;
        this.outer = outer;
        this.child = Objects.requireNonNull(child, "child is null");
        this.outputLayout = IntStream.concat(columns.stream().mapToInt(Column::getOutputIndex), Arrays.stream(child.getOutputLayout())).toArray();
        this.newRow = Objects.requireNonNull(newRow, "newRow is null");
    }

    @Override
    public void reset(JsonNode item, Page input, int position) {
        this.resetRoot(item, input, position, NO_PARAMETERS);
    }

    @Override
    public void resetRoot(JsonNode item, Page input, int position, Object[] pathParameters) {
        Objects.requireNonNull(pathParameters, "pathParameters is null");
        this.input = Objects.requireNonNull(input, "input is null");
        this.position = position;
        this.nextItemIndex = 0;
        this.processNextItem = true;
        this.sequence = SequenceEvaluator.getSequence(item, pathParameters, this.pathEvaluator, this.errorOnError);
    }

    @Override
    public boolean getRow() {
        do {
            boolean childProducedRow;
            if (this.processNextItem) {
                if (this.nextItemIndex >= this.sequence.size()) {
                    return false;
                }
                JsonNode currentItem = this.sequence.get(this.nextItemIndex);
                ++this.nextItemIndex;
                for (Column column : this.columns) {
                    this.newRow[column.getOutputIndex()] = column.evaluate(this.nextItemIndex, currentItem, this.input, this.position);
                }
                this.child.reset(currentItem, this.input, this.position);
                this.childAlreadyProduced = false;
                this.processNextItem = false;
            }
            if (childProducedRow = this.child.getRow()) {
                this.childAlreadyProduced = true;
                return true;
            }
            this.processNextItem = true;
        } while (!this.outer || this.childAlreadyProduced);
        this.appendNulls(this.child);
        return true;
    }

    private void appendNulls(JsonTableProcessingFragment fragment) {
        for (int column : fragment.getOutputLayout()) {
            this.newRow[column] = null;
        }
    }

    @Override
    public int[] getOutputLayout() {
        return this.outputLayout;
    }
}

