/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table.json.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.table.json.execution.JsonTableProcessingFragment;
import io.trino.spi.Page;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class FragmentUnion
implements JsonTableProcessingFragment {
    private final List<JsonTableProcessingFragment> siblings;
    private final int[] outputLayout;
    private final Object[] newRow;
    private int currentSiblingIndex;

    public FragmentUnion(List<JsonTableProcessingFragment> siblings, Object[] newRow) {
        this.siblings = ImmutableList.copyOf(siblings);
        Preconditions.checkArgument((siblings.size() >= 2 ? 1 : 0) != 0, (Object)"less than 2 siblings in Union node");
        this.outputLayout = siblings.stream().map(JsonTableProcessingFragment::getOutputLayout).flatMapToInt(Arrays::stream).toArray();
        this.newRow = Objects.requireNonNull(newRow, "newRow is null");
    }

    @Override
    public void reset(JsonNode item, Page input, int position) {
        Objects.requireNonNull(item, "item is null");
        Objects.requireNonNull(input, "input is null");
        this.siblings.stream().forEach(sibling -> sibling.reset(item, input, position));
        this.currentSiblingIndex = 0;
        this.appendNulls(this);
    }

    @Override
    public boolean getRow() {
        while (this.currentSiblingIndex < this.siblings.size()) {
            JsonTableProcessingFragment currentSibling = this.siblings.get(this.currentSiblingIndex);
            boolean currentSiblingProducedRow = currentSibling.getRow();
            if (currentSiblingProducedRow) {
                return true;
            }
            this.appendNulls(currentSibling);
            ++this.currentSiblingIndex;
        }
        return false;
    }

    private void appendNulls(JsonTableProcessingFragment fragment) {
        for (int column : fragment.getOutputLayout()) {
            this.newRow[column] = null;
        }
    }

    @Override
    public int[] getOutputLayout() {
        return this.outputLayout;
    }
}

