/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import java.util.Arrays;
import java.util.Objects;

public class ReplicatedBlockBuilder {
    private Block source;
    private int sourcePosition;

    public void resetInputBlock(Block source) {
        this.source = Objects.requireNonNull(source, "source is null");
        this.sourcePosition = 0;
    }

    public Block buildOutputBlock(int[] outputEntriesPerPosition, int offset, int inputBatchSize, int outputRowCount) {
        int[] ids = new int[outputRowCount];
        int fromPosition = 0;
        for (int i = 0; i < inputBatchSize; ++i) {
            int toPosition = fromPosition + outputEntriesPerPosition[offset + i];
            Arrays.fill(ids, fromPosition, toPosition, this.sourcePosition++);
            fromPosition = toPosition;
        }
        return DictionaryBlock.create((int)outputRowCount, (Block)this.source, (int[])ids);
    }
}

