/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Inject;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.Slice;
import io.trino.FeaturesConfig;
import io.trino.execution.buffer.PagesSerdeUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class PagesInputStreamFactory {
    public static final int SERIALIZED_PAGES_MAGIC = -22745087;
    private final boolean dataIntegrityVerificationEnabled;

    @Inject
    public PagesInputStreamFactory(FeaturesConfig featuresConfig) {
        this.dataIntegrityVerificationEnabled = featuresConfig.getExchangeDataIntegrityVerification() != FeaturesConfig.DataIntegrityVerification.NONE;
    }

    public void write(OutputStream stream, List<Slice> serializedPages) throws IOException {
        OutputStreamSliceOutput header = new OutputStreamSliceOutput(stream);
        header.writeInt(-22745087);
        header.writeLong(this.dataIntegrityVerificationEnabled ? PagesSerdeUtil.calculateChecksum(serializedPages) : 81985529216486895L);
        header.writeInt(serializedPages.size());
        header.flush();
        for (Slice page : serializedPages) {
            page.getInput().transferTo(stream);
            stream.flush();
        }
        stream.close();
    }
}

