/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.client.QueryData;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.EncodedQueryData;
import io.trino.client.spooling.Segment;
import io.trino.server.ExternalUriInfo;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.QueryResultRows;
import io.trino.server.protocol.spooling.CoordinatorSegmentResource;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.QueryDataProducer;
import io.trino.server.protocol.spooling.SpooledBlock;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import jakarta.ws.rs.core.UriBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class SpooledQueryDataProducer
implements QueryDataProducer {
    private final QueryDataEncoder.Factory encoderFactory;
    private QueryDataEncoder encoder;
    private long currentOffset;

    public SpooledQueryDataProducer(QueryDataEncoder.Factory encoderFactory) {
        this.encoderFactory = Objects.requireNonNull(encoderFactory, "encoderFactory is null");
    }

    @Override
    public QueryData produce(ExternalUriInfo uriInfo, Session session, QueryResultRows rows, Consumer<TrinoException> throwableConsumer) {
        if (rows.isEmpty()) {
            return null;
        }
        EncodedQueryData.Builder builder = EncodedQueryData.builder((String)this.encoderFactory.encoding());
        UriBuilder uriBuilder = CoordinatorSegmentResource.spooledSegmentUriBuilder(uriInfo);
        if (this.encoder == null) {
            this.encoder = this.encoderFactory.create(session, rows.getOutputColumns().orElseThrow());
            builder.withAttributes(this.encoder.attributes());
        }
        List<OutputColumn> outputColumns = rows.getOutputColumns().orElseThrow();
        try {
            for (Page page : rows.getPages()) {
                DataAttributes attributes;
                if (this.hasSpoolingMetadata(page, outputColumns.size())) {
                    SpooledBlock metadata = SpooledBlock.deserialize(page);
                    attributes = metadata.attributes().toBuilder().set(DataAttribute.ROW_OFFSET, (Object)this.currentOffset).build();
                    builder.withSegment(Segment.spooled((URI)metadata.directUri().orElseGet(() -> this.buildSegmentDownloadURI(uriBuilder, metadata.identifier())), (URI)this.buildSegmentAckURI(uriBuilder, metadata.identifier()), (DataAttributes)attributes, metadata.headers()));
                    this.currentOffset += ((Long)attributes.get(DataAttribute.ROWS_COUNT, Long.class)).longValue();
                    continue;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                attributes = this.encoder.encodeTo(output, List.of(page)).toBuilder().set(DataAttribute.ROW_OFFSET, (Object)this.currentOffset).build();
                builder.withSegment(Segment.inlined((byte[])output.toByteArray(), (DataAttributes)attributes));
                this.currentOffset += (long)page.getPositionCount();
            }
        }
        catch (IOException e) {
            throwableConsumer.accept(new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERIALIZATION_ERROR, "Failed to serialize query data", (Throwable)e));
        }
        catch (TrinoException e) {
            throwableConsumer.accept(e);
            return null;
        }
        return builder.build();
    }

    private URI buildSegmentDownloadURI(UriBuilder builder, Slice identifier) {
        return builder.clone().path("download/{identifier}").build(new Object[]{identifier.toStringUtf8()});
    }

    private URI buildSegmentAckURI(UriBuilder builder, Slice identifier) {
        return builder.clone().path("ack/{identifier}").build(new Object[]{identifier.toStringUtf8()});
    }

    private boolean hasSpoolingMetadata(Page page, int outputColumnsSize) {
        return page.getChannelCount() == outputColumnsSize + 1 && page.getPositionCount() == 1 && !page.getBlock(outputColumnsSize).isNull(0);
    }

    public static QueryDataProducer createSpooledQueryDataProducer(QueryDataEncoder.Factory encoder) {
        return new SpooledQueryDataProducer(encoder);
    }
}

