/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.Iterables;
import io.jsonwebtoken.JwtException;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.Authenticator;
import io.trino.server.security.UserMappingException;
import io.trino.spi.security.Identity;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.List;
import java.util.Optional;

public abstract class AbstractBearerAuthenticator
implements Authenticator {
    @Override
    public Identity authenticate(ContainerRequestContext request) throws AuthenticationException {
        return this.authenticate(request, this.extractToken(request));
    }

    public Identity authenticate(ContainerRequestContext request, String token) throws AuthenticationException {
        try {
            return this.createIdentity(token).orElseThrow(() -> this.needAuthentication(request, Optional.of(token), "Invalid credentials"));
        }
        catch (JwtException | UserMappingException e) {
            throw this.needAuthentication(request, Optional.empty(), e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    public String extractToken(ContainerRequestContext request) throws AuthenticationException {
        List headers = (List)request.getHeaders().get((Object)"Authorization");
        if (headers == null || headers.isEmpty()) {
            throw this.needAuthentication(request, Optional.empty(), null);
        }
        if (headers.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple %s headers detected: %s, where only single %s header is supported", "Authorization", headers, "Authorization"));
        }
        String header = (String)Iterables.getOnlyElement((Iterable)headers);
        int space = header.indexOf(32);
        if (space < 0 || !header.substring(0, space).equalsIgnoreCase("bearer")) {
            throw this.needAuthentication(request, Optional.empty(), null);
        }
        String token = header.substring(space + 1).trim();
        if (token.isEmpty()) {
            throw this.needAuthentication(request, Optional.empty(), null);
        }
        return token;
    }

    protected abstract Optional<Identity> createIdentity(String var1) throws UserMappingException;

    protected abstract AuthenticationException needAuthentication(ContainerRequestContext var1, Optional<String> var2, String var3);
}

