/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import com.google.inject.Inject;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Locator;
import io.trino.server.security.AbstractBearerAuthenticator;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import io.trino.server.security.jwt.ForJwt;
import io.trino.server.security.jwt.InvalidClaimException;
import io.trino.server.security.jwt.JwtAuthenticatorConfig;
import io.trino.server.security.jwt.JwtUtil;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.lang.runtime.SwitchBootstraps;
import java.security.Key;
import java.security.Principal;
import java.util.Collection;
import java.util.Optional;

public class JwtAuthenticator
extends AbstractBearerAuthenticator {
    private final JwtParser jwtParser;
    private final String principalField;
    private final UserMapping userMapping;
    private final Optional<String> requiredAudience;

    @Inject
    public JwtAuthenticator(JwtAuthenticatorConfig config, @ForJwt Locator<Key> signingKeyLocator) {
        this.principalField = config.getPrincipalField();
        this.requiredAudience = Optional.ofNullable(config.getRequiredAudience());
        JwtParserBuilder jwtParser = JwtUtil.newJwtParserBuilder().keyLocator(signingKeyLocator);
        if (config.getRequiredIssuer() != null) {
            jwtParser.requireIssuer(config.getRequiredIssuer());
        }
        this.jwtParser = jwtParser.build();
        this.userMapping = UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile());
    }

    @Override
    protected Optional<Identity> createIdentity(String token) throws UserMappingException {
        Claims claims = (Claims)this.jwtParser.parseSignedClaims((CharSequence)token).getPayload();
        this.validateAudience(claims);
        Optional<String> principal = Optional.ofNullable((String)claims.get(this.principalField, String.class));
        if (principal.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Identity.forUser((String)this.userMapping.mapUser(principal.get())).withPrincipal((Principal)new BasicPrincipal(principal.get())).build());
    }

    private void validateAudience(Claims claims) {
        Object tokenAudience;
        if (this.requiredAudience.isEmpty()) {
            return;
        }
        Object object = tokenAudience = claims.get((Object)"aud");
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Collection.class}, (Object)object, n)) {
            case 0: {
                String value = (String)object;
                if (this.requiredAudience.get().equals(value)) break;
                throw new InvalidClaimException(String.format("Invalid Audience: %s. Allowed audiences: %s", tokenAudience, this.requiredAudience.get()));
            }
            case 1: {
                Collection collection = (Collection)object;
                if (!collection.stream().noneMatch(aud -> this.requiredAudience.get().equals(aud))) break;
                throw new InvalidClaimException(String.format("Invalid Audience: %s. Allowed audiences: %s", tokenAudience, this.requiredAudience.get()));
            }
            case -1: {
                throw new InvalidClaimException(String.format("Expected %s claim to be: %s, but was not present in the JWT claims.", "aud", this.requiredAudience.get()));
            }
            default: {
                throw new InvalidClaimException(String.format("Invalid Audience: %s", tokenAudience));
            }
        }
    }

    @Override
    protected AuthenticationException needAuthentication(ContainerRequestContext request, Optional<String> currentToken, String message) {
        return new AuthenticationException(message, "Bearer realm=\"Trino\", token_type=\"JWT\"");
    }
}

