/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StringResponseHandler;
import io.trino.server.security.oauth2.ForOAuth2;
import io.trino.server.security.oauth2.NimbusHttpClient;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class NimbusAirliftHttpClient
implements NimbusHttpClient {
    private final HttpClient httpClient;

    @Inject
    public NimbusAirliftHttpClient(@ForOAuth2 HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    public Resource retrieveResource(URL url) throws IOException {
        try {
            StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(Request.Builder.prepareGet().setUri(url.toURI()).build(), (ResponseHandler)StringResponseHandler.createStringResponseHandler());
            return new Resource(response.getBody(), response.getHeader("Content-Type"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T execute(Request nimbusRequest, NimbusHttpClient.Parser<T> parser) {
        String query;
        HTTPRequest httpRequest = nimbusRequest.toHTTPRequest();
        HTTPRequest.Method method = httpRequest.getMethod();
        Request.Builder request = new Request.Builder().setMethod(method.name()).setFollowRedirects(httpRequest.getFollowRedirects());
        UriBuilder url = UriBuilder.fromUri((URI)httpRequest.getURI());
        if (method.equals((Object)HTTPRequest.Method.GET) || method.equals((Object)HTTPRequest.Method.DELETE)) {
            httpRequest.getQueryStringParameters().forEach((key, value) -> url.queryParam(key, value.toArray()));
        }
        url.fragment(httpRequest.getURL().getRef());
        request.setUri(url.build(new Object[0]));
        ImmutableMultimap.Builder headers = ImmutableMultimap.builder();
        httpRequest.getHeaderMap().forEach((arg_0, arg_1) -> ((ImmutableMultimap.Builder)headers).putAll(arg_0, arg_1));
        request.addHeaders((Multimap)headers.build());
        if ((method.equals((Object)HTTPRequest.Method.POST) || method.equals((Object)HTTPRequest.Method.PUT)) && (query = httpRequest.getBody()) != null) {
            request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)query, (Charset)StandardCharsets.UTF_8));
        }
        return (T)this.httpClient.execute(request.build(), new NimbusResponseHandler<T>(parser));
    }

    public static class NimbusResponseHandler<T>
    implements ResponseHandler<T, RuntimeException> {
        private final StringResponseHandler handler = StringResponseHandler.createStringResponseHandler();
        private final NimbusHttpClient.Parser<T> parser;

        public NimbusResponseHandler(NimbusHttpClient.Parser<T> parser) {
            this.parser = Objects.requireNonNull(parser, "parser is null");
        }

        public T handleException(io.airlift.http.client.Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((io.airlift.http.client.Request)request, (Throwable)exception);
        }

        public T handle(io.airlift.http.client.Request request, Response response) {
            StringResponseHandler.StringResponse stringResponse = this.handler.handle(request, response);
            HTTPResponse nimbusResponse = new HTTPResponse(response.getStatusCode());
            response.getHeaders().asMap().forEach((name, values) -> nimbusResponse.setHeader(name.toString(), values.toArray(new String[0])));
            nimbusResponse.setBody(stringResponse.getBody());
            try {
                return this.parser.parse(nimbusResponse);
            }
            catch (ParseException e) {
                throw new RuntimeException(String.format("Unable to parse response status=[%d], body=[%s]", stringResponse.getStatusCode(), stringResponse.getBody()), e);
            }
        }
    }
}

