/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.trino.Session;
import io.trino.metadata.FunctionResolver;
import io.trino.security.AccessControl;
import io.trino.spi.Location;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.WindowOperation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public final class ExpressionTreeUtils {
    private ExpressionTreeUtils() {
    }

    static List<FunctionCall> extractAggregateFunctions(Iterable<? extends Node> nodes, Session session, FunctionResolver functionResolver, AccessControl accessControl) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, function -> ExpressionTreeUtils.isAggregation(function, session, functionResolver, accessControl));
    }

    static List<Expression> extractWindowExpressions(Iterable<? extends Node> nodes) {
        return ImmutableList.builder().addAll(ExpressionTreeUtils.extractWindowFunctions(nodes)).addAll(ExpressionTreeUtils.extractWindowMeasures(nodes)).build();
    }

    static List<Expression> extractWindowExpressions(Iterable<? extends Node> nodes, Session session, FunctionResolver functionResolver, AccessControl accessControl) {
        return ImmutableList.builder().addAll(ExpressionTreeUtils.extractWindowFunctions(nodes, session, functionResolver, accessControl)).addAll(ExpressionTreeUtils.extractWindowMeasures(nodes)).build();
    }

    static List<FunctionCall> extractWindowFunctions(Iterable<? extends Node> nodes) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils::isWindowFunction);
    }

    static List<FunctionCall> extractWindowFunctions(Iterable<? extends Node> nodes, Session session, FunctionResolver functionResolver, AccessControl accessControl) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, function -> ExpressionTreeUtils.isWindow(function, session, functionResolver, accessControl));
    }

    static List<WindowOperation> extractWindowMeasures(Iterable<? extends Node> nodes) {
        return ExpressionTreeUtils.extractExpressions(nodes, WindowOperation.class);
    }

    public static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz) {
        return ExpressionTreeUtils.extractExpressions(nodes, clazz, Predicates.alwaysTrue());
    }

    private static boolean isAggregation(FunctionCall functionCall, Session session, FunctionResolver functionResolver, AccessControl accessControl) {
        return (functionResolver.isAggregationFunction(session, functionCall.getName(), accessControl) || functionCall.getFilter().isPresent() || functionCall.getOrderBy().isPresent()) && functionCall.getWindow().isEmpty();
    }

    private static boolean isWindow(FunctionCall functionCall, Session session, FunctionResolver functionResolver, AccessControl accessControl) {
        return functionCall.getWindow().isPresent() || functionResolver.isWindowFunction(session, functionCall.getName(), accessControl);
    }

    private static boolean isWindowFunction(FunctionCall functionCall) {
        return functionCall.getWindow().isPresent();
    }

    private static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz, Predicate<T> predicate) {
        Objects.requireNonNull(nodes, "nodes is null");
        Objects.requireNonNull(clazz, "clazz is null");
        Objects.requireNonNull(predicate, "predicate is null");
        return (List)Streams.stream(nodes).flatMap(node -> ExpressionTreeUtils.linearizeNodes(node).stream()).filter(clazz::isInstance).map(clazz::cast).filter(predicate).collect(ImmutableList.toImmutableList());
    }

    private static List<Node> linearizeNodes(Node node) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new DefaultExpressionTraversalVisitor<Void>(){

            public Void process(Node node, Void context) {
                super.process(node, (Object)context);
                nodes.add((Object)node);
                return null;
            }
        }.process(node, null);
        return nodes.build();
    }

    public static Optional<Location> extractLocation(Node node) {
        return node.getLocation().map(location -> new Location(location.getLineNumber(), location.getColumnNumber()));
    }

    public static QualifiedName asQualifiedName(Expression expression) {
        QualifiedName name = null;
        if (expression instanceof Identifier) {
            name = QualifiedName.of((String)((Identifier)expression).getValue());
        } else if (expression instanceof DereferenceExpression) {
            name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
        }
        return name;
    }
}

