/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.execution.Column;
import io.trino.execution.Input;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class InputExtractor {
    private final Metadata metadata;
    private final Session session;

    public InputExtractor(Metadata metadata, Session session) {
        this.metadata = metadata;
        this.session = session;
    }

    public List<Input> extractInputs(SubPlan root) {
        Visitor visitor = new Visitor();
        root.getAllFragments().forEach(fragment -> fragment.getRoot().accept(visitor, fragment.getId()));
        return ImmutableList.copyOf(visitor.getInputs());
    }

    private static Column createColumn(ColumnMetadata columnMetadata) {
        return new Column(columnMetadata.getName(), columnMetadata.getType().toString());
    }

    private Input createInput(Session session, TableHandle table, Set<Column> columns, PlanFragmentId fragmentId, PlanNodeId planNodeId) {
        CatalogSchemaTableName tableName = this.metadata.getTableName(session, table);
        SchemaTableName schemaTable = tableName.getSchemaTableName();
        Optional<Object> inputMetadata = this.metadata.getInfo(session, table);
        return new Input(tableName.getCatalogName(), table.catalogHandle().getVersion(), schemaTable.getSchemaName(), schemaTable.getTableName(), inputMetadata, (List<Column>)ImmutableList.copyOf(columns), fragmentId, planNodeId);
    }

    private class Visitor
    extends PlanVisitor<Void, PlanFragmentId> {
        private final ImmutableSet.Builder<Input> inputs = ImmutableSet.builder();

        private Visitor() {
        }

        public Set<Input> getInputs() {
            return this.inputs.build();
        }

        @Override
        public Void visitTableScan(TableScanNode node, PlanFragmentId fragmentId) {
            this.processScan(fragmentId, node.getId(), node.getTable(), node.getAssignments());
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, PlanFragmentId fragmentId) {
            this.processScan(fragmentId, node.getId(), node.getTableHandle(), node.getAssignments());
            return null;
        }

        private void processScan(PlanFragmentId fragmentId, PlanNodeId planNodeId, TableHandle tableHandle, Map<Symbol, ColumnHandle> assignments) {
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : assignments.values()) {
                columns.add(InputExtractor.createColumn(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            this.inputs.add((Object)InputExtractor.this.createInput(InputExtractor.this.session, tableHandle, columns, fragmentId, planNodeId));
        }

        @Override
        protected Void visitPlan(PlanNode node, PlanFragmentId fragmentId) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, fragmentId);
            }
            return null;
        }
    }
}

