/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ImplementFilteredAggregations
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(ImplementFilteredAggregations::hasFilters);

    private static boolean hasFilters(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().anyMatch(e -> e.getFilter().isPresent());
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        Assignments.Builder newAssignments = Assignments.builder();
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        ImmutableList.Builder maskSymbols = ImmutableList.builder();
        boolean aggregateWithoutFilterOrMaskPresent = false;
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregationNode.getAggregations().entrySet()) {
            Symbol output = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            Optional<Symbol> mask = aggregation.getMask();
            if (aggregation.getFilter().isPresent()) {
                Symbol filter = aggregation.getFilter().get();
                if (mask.isPresent()) {
                    Symbol newMask = context.getSymbolAllocator().newSymbol("mask", (Type)BooleanType.BOOLEAN);
                    Expression expression = IrUtils.and(mask.get().toSymbolReference(), filter.toSymbolReference());
                    newAssignments.put(newMask, expression);
                    mask = Optional.of(newMask);
                    maskSymbols.add((Object)newMask.toSymbolReference());
                } else {
                    mask = Optional.of(filter);
                    maskSymbols.add((Object)filter.toSymbolReference());
                }
            } else if (mask.isPresent()) {
                maskSymbols.add((Object)mask.get().toSymbolReference());
            } else {
                aggregateWithoutFilterOrMaskPresent = true;
            }
            aggregations.put((Object)output, (Object)new AggregationNode.Aggregation(aggregation.getResolvedFunction(), aggregation.getArguments(), aggregation.isDistinct(), Optional.empty(), aggregation.getOrderingScheme(), mask));
        }
        Expression predicate = Booleans.TRUE;
        if (!aggregationNode.hasNonEmptyGroupingSet() && !aggregateWithoutFilterOrMaskPresent) {
            predicate = IrUtils.combineDisjunctsWithDefault((Collection<Expression>)maskSymbols.build(), Booleans.TRUE);
        }
        newAssignments.putIdentities(aggregationNode.getSource().getOutputSymbols());
        return Rule.Result.ofPlanNode(AggregationNode.builderFrom(aggregationNode).setId(context.getIdAllocator().getNextId()).setSource(new FilterNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), aggregationNode.getSource(), newAssignments.build()), predicate)).setAggregations((Map<Symbol, AggregationNode.Aggregation>)aggregations.buildOrThrow()).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).build());
    }
}

