/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.math.DoubleMath;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.MathFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class RealOperators {
    private static final float MIN_SHORT_AS_FLOAT = -32768.0f;
    private static final float MAX_SHORT_PLUS_ONE_AS_FLOAT = 32768.0f;
    private static final float MIN_BYTE_AS_FLOAT = -128.0f;
    private static final float MAX_BYTE_PLUS_ONE_AS_FLOAT = 128.0f;
    private static final ThreadLocal<DecimalFormat> FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat("0.0#####E0", new DecimalFormatSymbols(Locale.ENGLISH)));

    private RealOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="real")
    public static long add(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) + Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="real")
    public static long subtract(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) - Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="real")
    public static long multiply(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) * Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="real")
    public static long divide(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) / Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="real")
    public static long modulus(@SqlType(value="real") long left, @SqlType(value="real") long right) {
        return Float.floatToRawIntBits(Float.intBitsToFloat((int)left) % Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="real")
    public static long negate(@SqlType(value="real") long value) {
        return Float.floatToRawIntBits(-Float.intBitsToFloat((int)value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@LiteralParameter(value="x") long x, @SqlType(value="real") long value) {
        float floatValue = Float.intBitsToFloat((int)value);
        String stringValue = floatValue == 0.0f ? (1.0f / floatValue > 0.0f ? "0E0" : "-0E0") : (Float.isInfinite(floatValue) ? (floatValue > 0.0f ? "Infinity" : "-Infinity") : FORMAT.get().format(Double.parseDouble(Float.toString(floatValue))));
        if ((long)stringValue.length() <= x) {
            return Slices.utf8Slice((String)stringValue);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Value %s (%s) cannot be represented as varchar(%s)", Float.valueOf(floatValue), stringValue, x));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToLong(@SqlType(value="real") long value) {
        float floatValue = Float.intBitsToFloat((int)value);
        if (Float.isNaN(floatValue)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast real NaN to bigint");
        }
        return (long)MathFunctions.round(floatValue);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="real") long value) {
        float floatValue = Float.intBitsToFloat((int)value);
        if (Float.isNaN(floatValue)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast real NaN to integer");
        }
        try {
            return Math.toIntExact((long)MathFunctions.round(floatValue));
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for integer: " + floatValue, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="real") long value) {
        float floatValue = Float.intBitsToFloat((int)value);
        if (Float.isNaN(floatValue)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast real NaN to smallint");
        }
        try {
            return Shorts.checkedCast((long)((long)MathFunctions.round(floatValue)));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for smallint: " + floatValue, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="real") long value) {
        float floatValue = Float.intBitsToFloat((int)value);
        if (Float.isNaN(floatValue)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast real NaN to tinyint");
        }
        try {
            return SignedBytes.checkedCast((long)((long)MathFunctions.round(floatValue)));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for tinyint: " + floatValue, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="real") long value) {
        return Float.intBitsToFloat((int)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="real") long value) {
        return Float.intBitsToFloat((int)value) != 0.0f;
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="smallint")
    public static long saturatedFloorCastToSmallint(@SqlType(value="real") long value) {
        return RealOperators.saturatedFloorCastToLong(value, -32768L, -32768.0f, 32767L, 32768.0f, "smallint");
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="tinyint")
    public static long saturatedFloorCastToTinyint(@SqlType(value="real") long value) {
        return RealOperators.saturatedFloorCastToLong(value, -128L, -128.0f, 127L, 128.0f, "tinyint");
    }

    private static long saturatedFloorCastToLong(long valueBits, long minValue, float minValueAsDouble, long maxValue, float maxValuePlusOneAsDouble, String targetType) {
        float value = Float.intBitsToFloat((int)valueBits);
        if (value <= minValueAsDouble) {
            return minValue;
        }
        if (value + 1.0f >= maxValuePlusOneAsDouble) {
            return maxValue;
        }
        try {
            return DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Unable to cast real %s to %s", Float.valueOf(value), targetType), (Throwable)e);
        }
    }
}

