/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import java.util.List;

public final class SpatialJoinUtils {
    public static final String ST_CONTAINS = "st_contains";
    public static final String ST_WITHIN = "st_within";
    public static final String ST_INTERSECTS = "st_intersects";
    public static final String ST_DISTANCE = "st_distance";

    private SpatialJoinUtils() {
    }

    public static List<Call> extractSupportedSpatialFunctions(Expression filterExpression) {
        return (List)IrUtils.extractConjuncts(filterExpression).stream().filter(Call.class::isInstance).map(Call.class::cast).filter(SpatialJoinUtils::isSupportedSpatialFunction).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialFunction(Call call) {
        CatalogSchemaFunctionName functionName = call.function().name();
        return functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(ST_CONTAINS)) || functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(ST_WITHIN)) || functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName(ST_INTERSECTS));
    }

    public static List<Comparison> extractSupportedSpatialComparisons(Expression filterExpression) {
        return (List)IrUtils.extractConjuncts(filterExpression).stream().filter(Comparison.class::isInstance).map(Comparison.class::cast).filter(SpatialJoinUtils::isSupportedSpatialComparison).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSupportedSpatialComparison(Comparison expression) {
        return switch (expression.operator()) {
            case Comparison.Operator.LESS_THAN, Comparison.Operator.LESS_THAN_OR_EQUAL -> SpatialJoinUtils.isSTDistance(expression.left());
            case Comparison.Operator.GREATER_THAN, Comparison.Operator.GREATER_THAN_OR_EQUAL -> SpatialJoinUtils.isSTDistance(expression.right());
            default -> false;
        };
    }

    private static boolean isSTDistance(Expression expression) {
        if (expression instanceof Call) {
            Call call = (Call)expression;
            return call.function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName(ST_DISTANCE));
        }
        return false;
    }
}

