/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.trace;

import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.trace.SpanId;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.api.trace.TraceId;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.internal.RandomSupplier;
import com.google.cloud.hadoop.repackaged.gcs.io.opentelemetry.sdk.trace.IdGenerator;
import java.util.Random;
import java.util.function.Supplier;

enum RandomIdGenerator implements IdGenerator
{
    INSTANCE;

    private static final long INVALID_ID = 0L;
    private static final Supplier<Random> randomSupplier;

    @Override
    public String generateSpanId() {
        long id;
        Random random = randomSupplier.get();
        while ((id = random.nextLong()) == 0L) {
        }
        return SpanId.fromLong(id);
    }

    @Override
    public String generateTraceId() {
        long idLo;
        Random random = randomSupplier.get();
        long idHi = random.nextLong();
        while ((idLo = random.nextLong()) == 0L) {
        }
        return TraceId.fromLongs(idHi, idLo);
    }

    public String toString() {
        return "RandomIdGenerator{}";
    }

    static {
        randomSupplier = RandomSupplier.platformDefault();
    }
}

