/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.SerializableByteBufferMap;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.SupportsIndexProjection;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.SerializableMap;

abstract class BaseFile<F>
extends SupportsIndexProjection
implements ContentFile<F>,
IndexedRecord,
StructLike,
SpecificData.SchemaConstructable,
Serializable {
    private static final FileContent[] FILE_CONTENT_VALUES = FileContent.values();
    static final Types.StructType EMPTY_STRUCT_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[0]);
    static final PartitionData EMPTY_PARTITION_DATA = new PartitionData(EMPTY_STRUCT_TYPE){

        @Override
        public PartitionData copy() {
            return this;
        }
    };
    private Types.StructType partitionType;
    private Long fileOrdinal = null;
    private String manifestLocation = null;
    private int partitionSpecId = -1;
    private FileContent content = FileContent.DATA;
    private String filePath = null;
    private FileFormat format = null;
    private PartitionData partitionData = null;
    private Long recordCount = null;
    private long fileSizeInBytes = -1L;
    private Long dataSequenceNumber = null;
    private Long fileSequenceNumber = null;
    private Map<Integer, Long> columnSizes = null;
    private Map<Integer, Long> valueCounts = null;
    private Map<Integer, Long> nullValueCounts = null;
    private Map<Integer, Long> nanValueCounts = null;
    private Map<Integer, ByteBuffer> lowerBounds = null;
    private Map<Integer, ByteBuffer> upperBounds = null;
    private long[] splitOffsets = null;
    private int[] equalityIds = null;
    private byte[] keyMetadata = null;
    private Integer sortOrderId;
    private transient Schema avroSchema = null;
    private static final Types.StructType BASE_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{DataFile.CONTENT, DataFile.FILE_PATH, DataFile.FILE_FORMAT, DataFile.SPEC_ID, Types.NestedField.required((int)102, (String)"partition", (Type)EMPTY_STRUCT_TYPE, (String)"Partition data tuple, schema based on the partition spec"), DataFile.RECORD_COUNT, DataFile.FILE_SIZE, DataFile.COLUMN_SIZES, DataFile.VALUE_COUNTS, DataFile.NULL_VALUE_COUNTS, DataFile.NAN_VALUE_COUNTS, DataFile.LOWER_BOUNDS, DataFile.UPPER_BOUNDS, DataFile.KEY_METADATA, DataFile.SPLIT_OFFSETS, DataFile.EQUALITY_IDS, DataFile.SORT_ORDER_ID, MetadataColumns.ROW_POSITION});

    BaseFile(Schema avroSchema) {
        this(AvroSchemaUtil.convert(avroSchema).asStructType());
        this.avroSchema = avroSchema;
    }

    BaseFile(Types.StructType projection) {
        super(BASE_TYPE, projection);
        this.avroSchema = AvroSchemaUtil.convert(projection, "data_file");
        Type partType = projection.fieldType("partition");
        this.partitionType = partType != null ? partType.asNestedType().asStructType() : EMPTY_STRUCT_TYPE;
        this.partitionData = new PartitionData(this.partitionType);
    }

    BaseFile(int specId, FileContent content, String filePath, FileFormat format, PartitionData partition, long fileSizeInBytes, long recordCount, Map<Integer, Long> columnSizes, Map<Integer, Long> valueCounts, Map<Integer, Long> nullValueCounts, Map<Integer, Long> nanValueCounts, Map<Integer, ByteBuffer> lowerBounds, Map<Integer, ByteBuffer> upperBounds, List<Long> splitOffsets, int[] equalityFieldIds, Integer sortOrderId, ByteBuffer keyMetadata) {
        super(BASE_TYPE.fields().size());
        this.partitionSpecId = specId;
        this.content = content;
        this.filePath = filePath;
        this.format = format;
        if (partition == null) {
            this.partitionData = EMPTY_PARTITION_DATA;
            this.partitionType = EMPTY_PARTITION_DATA.getPartitionType();
        } else {
            this.partitionData = partition;
            this.partitionType = partition.getPartitionType();
        }
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.columnSizes = columnSizes;
        this.valueCounts = valueCounts;
        this.nullValueCounts = nullValueCounts;
        this.nanValueCounts = nanValueCounts;
        this.lowerBounds = SerializableByteBufferMap.wrap(lowerBounds);
        this.upperBounds = SerializableByteBufferMap.wrap(upperBounds);
        this.splitOffsets = ArrayUtil.toLongArray(splitOffsets);
        this.equalityIds = equalityFieldIds;
        this.sortOrderId = sortOrderId;
        this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)keyMetadata);
    }

    BaseFile(BaseFile<F> toCopy, boolean copyStats, Set<Integer> requestedColumnIds) {
        super(toCopy);
        this.fileOrdinal = toCopy.fileOrdinal;
        this.manifestLocation = toCopy.manifestLocation;
        this.partitionSpecId = toCopy.partitionSpecId;
        this.content = toCopy.content;
        this.filePath = toCopy.filePath;
        this.format = toCopy.format;
        this.partitionData = toCopy.partitionData.copy();
        this.partitionType = toCopy.partitionType;
        this.recordCount = toCopy.recordCount;
        this.fileSizeInBytes = toCopy.fileSizeInBytes;
        if (copyStats) {
            this.columnSizes = BaseFile.copyMap(toCopy.columnSizes, requestedColumnIds);
            this.valueCounts = BaseFile.copyMap(toCopy.valueCounts, requestedColumnIds);
            this.nullValueCounts = BaseFile.copyMap(toCopy.nullValueCounts, requestedColumnIds);
            this.nanValueCounts = BaseFile.copyMap(toCopy.nanValueCounts, requestedColumnIds);
            this.lowerBounds = BaseFile.copyByteBufferMap(toCopy.lowerBounds, requestedColumnIds);
            this.upperBounds = BaseFile.copyByteBufferMap(toCopy.upperBounds, requestedColumnIds);
        } else {
            this.columnSizes = null;
            this.valueCounts = null;
            this.nullValueCounts = null;
            this.nanValueCounts = null;
            this.lowerBounds = null;
            this.upperBounds = null;
        }
        this.keyMetadata = toCopy.keyMetadata == null ? null : Arrays.copyOf(toCopy.keyMetadata, toCopy.keyMetadata.length);
        this.splitOffsets = toCopy.splitOffsets == null ? null : Arrays.copyOf(toCopy.splitOffsets, toCopy.splitOffsets.length);
        this.equalityIds = toCopy.equalityIds != null ? Arrays.copyOf(toCopy.equalityIds, toCopy.equalityIds.length) : null;
        this.sortOrderId = toCopy.sortOrderId;
        this.dataSequenceNumber = toCopy.dataSequenceNumber;
        this.fileSequenceNumber = toCopy.fileSequenceNumber;
    }

    BaseFile() {
        super(BASE_TYPE.fields().size());
    }

    public int specId() {
        return this.partitionSpecId;
    }

    void setSpecId(int specId) {
        this.partitionSpecId = specId;
    }

    public Long dataSequenceNumber() {
        return this.dataSequenceNumber;
    }

    public void setDataSequenceNumber(Long dataSequenceNumber) {
        this.dataSequenceNumber = dataSequenceNumber;
    }

    void setManifestLocation(String manifestLocation) {
        this.manifestLocation = manifestLocation;
    }

    public Long fileSequenceNumber() {
        return this.fileSequenceNumber;
    }

    public void setFileSequenceNumber(Long fileSequenceNumber) {
        this.fileSequenceNumber = fileSequenceNumber;
    }

    protected abstract Schema getAvroSchema(Types.StructType var1);

    public Schema getSchema() {
        if (this.avroSchema == null) {
            this.avroSchema = this.getAvroSchema(this.partitionType);
        }
        return this.avroSchema;
    }

    public void put(int i, Object value) {
        this.set(i, value);
    }

    @Override
    protected <T> void internalSet(int pos, T value) {
        switch (pos) {
            case 0: {
                this.content = value != null ? FILE_CONTENT_VALUES[(Integer)value] : FileContent.DATA;
                return;
            }
            case 1: {
                this.filePath = value.toString();
                return;
            }
            case 2: {
                this.format = FileFormat.fromString((String)value.toString());
                return;
            }
            case 3: {
                this.partitionSpecId = value != null ? (Integer)value : -1;
                return;
            }
            case 4: {
                this.partitionData = (PartitionData)value;
                return;
            }
            case 5: {
                this.recordCount = (Long)value;
                return;
            }
            case 6: {
                this.fileSizeInBytes = (Long)value;
                return;
            }
            case 7: {
                this.columnSizes = (Map)value;
                return;
            }
            case 8: {
                this.valueCounts = (Map)value;
                return;
            }
            case 9: {
                this.nullValueCounts = (Map)value;
                return;
            }
            case 10: {
                this.nanValueCounts = (Map)value;
                return;
            }
            case 11: {
                this.lowerBounds = SerializableByteBufferMap.wrap((Map)value);
                return;
            }
            case 12: {
                this.upperBounds = SerializableByteBufferMap.wrap((Map)value);
                return;
            }
            case 13: {
                this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
                return;
            }
            case 14: {
                this.splitOffsets = ArrayUtil.toLongArray((List)value);
                return;
            }
            case 15: {
                this.equalityIds = ArrayUtil.toIntArray((List)value);
                return;
            }
            case 16: {
                this.sortOrderId = (Integer)value;
                return;
            }
            case 17: {
                this.fileOrdinal = (long)((Long)value);
                return;
            }
        }
    }

    @Override
    protected <T> T internalGet(int pos, Class<T> javaClass) {
        return javaClass.cast(this.getByPos(pos));
    }

    private Object getByPos(int basePos) {
        switch (basePos) {
            case 0: {
                return this.content.id();
            }
            case 1: {
                return this.filePath;
            }
            case 2: {
                return this.format != null ? this.format.toString() : null;
            }
            case 3: {
                return this.partitionSpecId;
            }
            case 4: {
                return this.partitionData;
            }
            case 5: {
                return this.recordCount;
            }
            case 6: {
                return this.fileSizeInBytes;
            }
            case 7: {
                return this.columnSizes;
            }
            case 8: {
                return this.valueCounts;
            }
            case 9: {
                return this.nullValueCounts;
            }
            case 10: {
                return this.nanValueCounts;
            }
            case 11: {
                return this.lowerBounds;
            }
            case 12: {
                return this.upperBounds;
            }
            case 13: {
                return this.keyMetadata();
            }
            case 14: {
                return this.splitOffsets();
            }
            case 15: {
                return this.equalityFieldIds();
            }
            case 16: {
                return this.sortOrderId;
            }
            case 17: {
                return this.fileOrdinal;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + basePos);
    }

    public Object get(int pos) {
        return this.get(pos, Object.class);
    }

    @Override
    public int size() {
        return DataFile.getType((Types.StructType)EMPTY_STRUCT_TYPE).fields().size();
    }

    public Long pos() {
        return this.fileOrdinal;
    }

    public String manifestLocation() {
        return this.manifestLocation;
    }

    public FileContent content() {
        return this.content;
    }

    public CharSequence path() {
        return this.filePath;
    }

    public FileFormat format() {
        return this.format;
    }

    public StructLike partition() {
        return this.partitionData;
    }

    public long recordCount() {
        return this.recordCount;
    }

    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public Map<Integer, Long> columnSizes() {
        return BaseFile.toReadableMap(this.columnSizes);
    }

    public Map<Integer, Long> valueCounts() {
        return BaseFile.toReadableMap(this.valueCounts);
    }

    public Map<Integer, Long> nullValueCounts() {
        return BaseFile.toReadableMap(this.nullValueCounts);
    }

    public Map<Integer, Long> nanValueCounts() {
        return BaseFile.toReadableMap(this.nanValueCounts);
    }

    public Map<Integer, ByteBuffer> lowerBounds() {
        return BaseFile.toReadableByteBufferMap(this.lowerBounds);
    }

    public Map<Integer, ByteBuffer> upperBounds() {
        return BaseFile.toReadableByteBufferMap(this.upperBounds);
    }

    public ByteBuffer keyMetadata() {
        return this.keyMetadata != null ? ByteBuffer.wrap(this.keyMetadata) : null;
    }

    public List<Long> splitOffsets() {
        if (this.hasWellDefinedOffsets()) {
            return ArrayUtil.toUnmodifiableLongList(this.splitOffsets);
        }
        return null;
    }

    long[] splitOffsetArray() {
        if (this.hasWellDefinedOffsets()) {
            return this.splitOffsets;
        }
        return null;
    }

    private boolean hasWellDefinedOffsets() {
        return this.splitOffsets != null && this.splitOffsets.length != 0 && this.splitOffsets[this.splitOffsets.length - 1] < this.fileSizeInBytes;
    }

    public List<Integer> equalityFieldIds() {
        return ArrayUtil.toIntList(this.equalityIds);
    }

    public Integer sortOrderId() {
        return this.sortOrderId;
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> map, Set<K> keys) {
        return keys == null ? SerializableMap.copyOf(map) : SerializableMap.filteredCopyOf(map, keys);
    }

    private static Map<Integer, ByteBuffer> copyByteBufferMap(Map<Integer, ByteBuffer> map, Set<Integer> keys) {
        return SerializableByteBufferMap.wrap(BaseFile.copyMap(map, keys));
    }

    private static <K, V> Map<K, V> toReadableMap(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof SerializableMap) {
            return ((SerializableMap)map).immutableMap();
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<Integer, ByteBuffer> toReadableByteBufferMap(Map<Integer, ByteBuffer> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof SerializableByteBufferMap) {
            return ((SerializableByteBufferMap)map).immutableMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content.toString().toLowerCase(Locale.ROOT)).add("file_path", (Object)this.filePath).add("file_format", (Object)this.format).add("spec_id", this.specId()).add("partition", (Object)this.partitionData).add("record_count", (Object)this.recordCount).add("file_size_in_bytes", this.fileSizeInBytes).add("column_sizes", this.columnSizes).add("value_counts", this.valueCounts).add("null_value_counts", this.nullValueCounts).add("nan_value_counts", this.nanValueCounts).add("lower_bounds", this.lowerBounds).add("upper_bounds", this.upperBounds).add("key_metadata", (Object)(this.keyMetadata == null ? "null" : "(redacted)")).add("split_offsets", this.splitOffsets == null ? "null" : this.splitOffsets()).add("equality_ids", this.equalityIds == null ? "null" : this.equalityFieldIds()).add("sort_order_id", (Object)this.sortOrderId).add("data_sequence_number", this.dataSequenceNumber == null ? "null" : this.dataSequenceNumber).add("file_sequence_number", this.fileSequenceNumber == null ? "null" : this.fileSequenceNumber).toString();
    }
}

